/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.init;

import codechicken.enderstorage.client.render.item.EnderChestItemRender;
import codechicken.enderstorage.client.render.item.EnderTankItemRender;
import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.datagen.ItemModelProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="enderstorage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherDataGenerators(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper files = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeClient(), (DataProvider)new BlockStates(output, files));
        gen.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, files));
        gen.addProvider(event.includeServer(), (DataProvider)new BlockTagGen(output, lookupProvider, files));
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
            super(output, "enderstorage", exFileHelper);
        }

        @Nonnull
        public String m_6055_() {
            return "EnderStorage BlockStates";
        }

        protected void registerStatesAndModels() {
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("dummy", "block")).texture("particle", "minecraft:block/obsidian");
            this.simpleBlock((Block)EnderStorageModContent.ENDER_CHEST_BLOCK.get(), (ModelFile)model);
            this.simpleBlock((Block)EnderStorageModContent.ENDER_TANK_BLOCK.get(), (ModelFile)model);
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "enderstorage", existingFileHelper);
        }

        protected void registerModels() {
            this.clazz((Supplier)EnderStorageModContent.ENDER_CHEST_ITEM, EnderChestItemRender.class);
            this.clazz((Supplier)EnderStorageModContent.ENDER_TANK_ITEM, EnderTankItemRender.class);
            ItemModelProvider.CompositeLoaderBuilder bag = ((ItemModelProvider.CompositeLoaderBuilder)this.generated((Supplier)EnderStorageModContent.ENDER_POUCH).noTexture().customLoader(ItemModelProvider.CompositeLoaderBuilder::ccl)).nested("bag", e -> {
                e.parent((ModelFile)GENERATED).noTexture();
                e.override(o -> {
                    o.predicate(this.modLoc("open"), 0.0f);
                    o.predicate(this.modLoc("owned"), 0.0f);
                    o.model("ender_pouch_closed", m -> m.parent((ModelFile)GENERATED).texture("layer0", this.modLoc("item/pouch/closed")));
                });
                e.override(o -> {
                    o.predicate(this.modLoc("open"), 1.0f);
                    o.predicate(this.modLoc("owned"), 0.0f);
                    o.model("ender_pouch_open", m -> m.parent((ModelFile)GENERATED).texture("layer0", this.modLoc("item/pouch/open")));
                });
                e.override(o -> {
                    o.predicate(this.modLoc("open"), 0.0f);
                    o.predicate(this.modLoc("owned"), 1.0f);
                    o.model("ender_pouch_owned_closed", m -> m.parent((ModelFile)GENERATED).texture("layer0", this.modLoc("item/pouch/owned_closed")));
                });
                e.override(o -> {
                    o.predicate(this.modLoc("open"), 1.0f);
                    o.predicate(this.modLoc("owned"), 1.0f);
                    o.model("ender_pouch_owned_open", m -> m.parent((ModelFile)GENERATED).texture("layer0", this.modLoc("item/pouch/owned_open")));
                });
            });
            for (String side : new String[]{"left", "middle", "right"}) {
                bag.nested(side, e -> {
                    e.parent((ModelFile)GENERATED).noTexture();
                    for (EnumColour colour : EnumColour.values()) {
                        String col = colour.m_7912_();
                        e.override(o -> {
                            o.predicate(this.modLoc(side), (float)colour.ordinal());
                            o.model("ender_pouch_button_" + side + "_" + col, m -> m.parent((ModelFile)GENERATED).texture(this.modLoc("item/pouch/buttons/" + side + "/" + col)));
                        });
                    }
                });
            }
        }

        public String m_6055_() {
            return "EnderStorage Item models";
        }
    }

    private static class BlockTagGen
    extends BlockTagsProvider {
        public BlockTagGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "enderstorage", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider pProvider) {
            this.m_206424_(BlockTags.f_144282_).m_255245_((Object)((Block)EnderStorageModContent.ENDER_CHEST_BLOCK.get())).m_255245_((Object)((Block)EnderStorageModContent.ENDER_TANK_BLOCK.get()));
        }
    }
}

