/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render.tile;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.block.BlockEnderTank;
import codechicken.enderstorage.client.model.ButtonModelLibrary;
import codechicken.enderstorage.client.render.RenderCustomEndPortal;
import codechicken.enderstorage.tile.TileEnderTank;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.fluid.FluidUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.UVTranslation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RenderTileEnderTank
implements BlockEntityRenderer<TileEnderTank> {
    private static final RenderType baseType = RenderType.m_110452_((ResourceLocation)new ResourceLocation("enderstorage:textures/endertank.png"));
    private static final RenderType buttonType = RenderType.m_110446_((ResourceLocation)new ResourceLocation("enderstorage:textures/buttons.png"));
    private static final RenderType pearlType = CCModelLibrary.getIcos4RenderType((ResourceLocation)new ResourceLocation("enderstorage:textures/hedronmap.png"));
    public static final CCModel tankModel;
    public static final CCModel valveModel;
    public static final CCModel[] buttons;
    public static final RenderCustomEndPortal renderEndPortal;

    public RenderTileEnderTank(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEnderTank enderTank, float partialTicks, PoseStack mStack, MultiBufferSource source, int packedLight, int packedOverlay) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        float valveRot = (float)MathHelper.interpolate((double)enderTank.pressure_state.b_rotate, (double)enderTank.pressure_state.a_rotate, (double)partialTicks) * 0.01745f;
        int pearlOffset = RenderUtils.getTimeOffset((BlockPos)enderTank.m_58899_());
        Matrix4 mat = new Matrix4(mStack);
        RenderTileEnderTank.renderTank(ccrs, mat.copy(), source, enderTank.rotation, valveRot, enderTank.getFrequency(), pearlOffset);
        RenderTileEnderTank.renderFluid(ccrs, mat, source, enderTank.liquid_state.c_liquid);
        ccrs.reset();
    }

    public static void renderTank(CCRenderState ccrs, Matrix4 mat, MultiBufferSource buffers, int rotation, float valveRot, Frequency freq, int pearlOffset) {
        renderEndPortal.render(mat, buffers);
        ccrs.reset();
        mat.translate(0.5, 0.0, 0.5);
        mat.rotate((double)(-90 * (rotation + 2)) * 0.017453292519943, Vector3.Y_POS);
        ccrs.bind(baseType, buffers);
        tankModel.render(ccrs, new IVertexOperation[]{mat});
        Matrix4 valveMat = mat.copy().apply(new Rotation((double)valveRot, Vector3.Z_POS).at(new Vector3(0.0, 0.4165, 0.0)));
        valveModel.render(ccrs, new IVertexOperation[]{valveMat, new UVTranslation(0.0, freq.hasOwner() ? 0.203125 : 0.0)});
        ccrs.bind(buttonType, buffers);
        EnumColour[] colours = freq.toArray();
        for (int i = 0; i < 3; ++i) {
            buttons[i].render(ccrs, new IVertexOperation[]{mat, new UVTranslation(0.25 * (double)(colours[i].getWoolMeta() % 4), 0.25 * (double)(colours[i].getWoolMeta() / 4))});
        }
        double time = ClientUtils.getRenderTime() + (double)pearlOffset;
        Matrix4 pearlMat = RenderUtils.getMatrix((Matrix4)mat.copy(), (Vector3)new Vector3(0.0, 0.45 + (double)(RenderUtils.getPearlBob((double)time) * 2.0f), 0.0), (Rotation)new Rotation(time / 3.0, Vector3.Y_POS), (double)0.04);
        ccrs.brightness = 0xF000F0;
        ccrs.bind(pearlType, buffers);
        CCModelLibrary.icosahedron4.render(ccrs, new IVertexOperation[]{pearlMat});
        ccrs.reset();
    }

    public static void renderFluid(CCRenderState ccrs, Matrix4 mat, MultiBufferSource getter, FluidStack stack) {
        RenderUtils.renderFluidCuboid((CCRenderState)ccrs, (Matrix4)mat, (RenderType)RenderUtils.getFluidRenderType(), (MultiBufferSource)getter, (FluidStack)stack, (Cuboid6)new Cuboid6(0.22, 0.12, 0.22, 0.78, 0.751, 0.78), (double)((double)stack.getAmount() / (16.0 * (double)FluidUtils.B)), (double)0.75);
    }

    static {
        renderEndPortal = new RenderCustomEndPortal(0.1205, 0.24, 0.76, 0.24, 0.76);
        Map models = new OBJParser(new ResourceLocation("enderstorage:models/endertank.obj")).quads().swapYZ().parse();
        Translation fix = new Translation(-0.5099, 0.0, -0.5027);
        valveModel = ((CCModel)models.remove("Valve")).apply((Transformation)fix).computeNormals();
        tankModel = CCModel.combine(models.values()).apply((Transformation)fix).computeNormals().shrinkUVs(0.004);
        buttons = new CCModel[3];
        for (int i = 0; i < 3; ++i) {
            RenderTileEnderTank.buttons[i] = ButtonModelLibrary.button.copy().apply((Transformation)BlockEnderTank.buttonT[i].with((Transformation)new Translation(-0.5, 0.0, -0.5)));
        }
    }
}

