/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree.builder.position;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.tree.TreePartType;
import fr.rakambda.fallingtree.common.tree.builder.ToAnalyzePos;
import fr.rakambda.fallingtree.common.tree.builder.position.IPositionFetcher;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class BasicPositionFetcher
implements IPositionFetcher {
    private static BasicPositionFetcher INSTANCE;
    @NotNull
    private final FallingTreeCommon<?> mod;

    @Override
    @NotNull
    public Collection<ToAnalyzePos> getPositions(@NotNull ILevel level, @NotNull IBlockPos originPos, @NotNull ToAnalyzePos parent) {
        IBlockPos parentPos = parent.checkPos();
        IBlock parentBlock = level.getBlockState(parentPos).getBlock();
        return parentPos.betweenClosedStream(parentPos.above().north().east(), parentPos.below().south().west()).map(checkPos -> {
            IBlock checkBlock = level.getBlockState((IBlockPos)checkPos).getBlock();
            TreePartType treePart = this.mod.getTreePart(checkBlock);
            int logSequence = treePart == TreePartType.LOG ? 0 : parent.sequenceSinceLastLog() + 1;
            return new ToAnalyzePos(this, parentPos, parentBlock, checkPos.immutable(), checkBlock, treePart, parent.sequence() + 1, logSequence);
        }).collect(Collectors.toList());
    }

    @NotNull
    public static BasicPositionFetcher getInstance(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new BasicPositionFetcher(common);
        }
        return INSTANCE;
    }

    private BasicPositionFetcher(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

