/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib.geometry;

import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public abstract class ConstraintImpl<T extends ConstraintImpl<?>>
implements Constraint {
    protected boolean precise = false;
    protected Axis axis = null;
    private double value;
    private boolean isDirty = true;

    public boolean isPrecise() {
        return this.precise;
    }

    public T precise() {
        this.precise = true;
        return (T)this;
    }

    @Override
    public double get() {
        if (this.isDirty) {
            this.value = this.isPrecise() ? this.getImpl() : (double)((int)this.getImpl());
            this.isDirty = false;
        }
        return this.value;
    }

    @Override
    @Nullable
    public Axis axis() {
        return this.axis;
    }

    public T setAxis(@Nullable Axis axis) {
        this.axis = axis;
        return (T)this;
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    protected abstract double getImpl();

    public static class MidPointDynamic
    extends ConstraintImpl<MidPointDynamic> {
        protected final GeoRef start;
        protected final GeoRef end;
        protected final Supplier<Double> offset;

        public MidPointDynamic(GeoRef start, GeoRef end, Supplier<Double> offset) {
            this.setAxis(start.parameter.axis);
            if (start.parameter.axis != end.parameter.axis) {
                throw new IllegalStateException("Attempted to define a 'MidPoint' Constraint with parameters on different axes.");
            }
            this.start = start;
            this.end = end;
            this.offset = offset;
        }

        @Override
        protected double getImpl() {
            return this.start.get() + (this.end.get() - this.start.get()) / 2.0 + this.getOffset();
        }

        public double getOffset() {
            return this.offset.get();
        }

        public double getStart() {
            return this.start.get();
        }

        public double getEnd() {
            return this.end.get();
        }
    }

    public static class MidPoint
    extends ConstraintImpl<MidPoint> {
        protected final GeoRef start;
        protected final GeoRef end;
        protected final double offset;

        public MidPoint(GeoRef start, GeoRef end, double offset) {
            this.setAxis(start.parameter.axis);
            if (start.parameter.axis != end.parameter.axis) {
                throw new IllegalStateException("Attempted to define a 'MidPoint' Constraint with parameters on different axes.");
            }
            this.start = start;
            this.end = end;
            this.offset = offset;
        }

        @Override
        protected double getImpl() {
            return this.start.get() + (this.end.get() - this.start.get()) / 2.0 + this.getOffset();
        }

        public double getOffset() {
            return this.offset;
        }

        public double getStart() {
            return this.start.get();
        }

        public double getEnd() {
            return this.end.get();
        }
    }

    public static class BetweenOffsetDynamic
    extends BetweenDynamic {
        private final Supplier<Double> offset;

        public BetweenOffsetDynamic(GeoRef start, GeoRef end, Supplier<Double> pos, Supplier<Double> offset) {
            super(start, end, pos);
            this.offset = offset;
        }

        @Override
        protected double getImpl() {
            return super.getImpl() + this.offset.get();
        }
    }

    public static class BetweenOffset
    extends Between {
        private final double offset;

        public BetweenOffset(GeoRef start, GeoRef end, double pos, double offset) {
            super(start, end, pos);
            this.offset = offset;
        }

        @Override
        protected double getImpl() {
            return super.getImpl() + this.offset;
        }
    }

    public static class BetweenDynamic
    extends ConstraintImpl<BetweenDynamic> {
        protected final GeoRef start;
        protected final GeoRef end;
        protected final Supplier<Double> pos;
        protected boolean clamp = false;

        public BetweenDynamic(GeoRef start, GeoRef end, Supplier<Double> pos) {
            this.setAxis(start.parameter.axis);
            if (start.parameter.axis != end.parameter.axis) {
                throw new IllegalStateException("Attempted to define a 'Between' Constraint with parameters on different axes.");
            }
            this.start = start;
            this.end = end;
            this.pos = pos;
        }

        @Override
        protected double getImpl() {
            return this.start.get() + (this.end.get() - this.start.get()) * this.getPos();
        }

        public double getPos() {
            return this.clamp ? Mth.m_14008_((double)this.pos.get(), (double)0.0, (double)1.0) : this.pos.get();
        }

        public double getStart() {
            return this.start.get();
        }

        public double getEnd() {
            return this.end.get();
        }

        public BetweenDynamic clamp() {
            this.clamp = true;
            return this;
        }
    }

    public static class Between
    extends ConstraintImpl<Between> {
        protected final GeoRef start;
        protected final GeoRef end;
        protected final double pos;
        protected boolean clamp = false;

        public Between(GeoRef start, GeoRef end, double pos) {
            this.setAxis(start.parameter.axis);
            if (start.parameter.axis != end.parameter.axis) {
                throw new IllegalStateException("Attempted to define a 'Between' Constraint with parameters on different axes.");
            }
            this.start = start;
            this.end = end;
            this.pos = pos;
        }

        @Override
        protected double getImpl() {
            return this.start.get() + (this.end.get() - this.start.get()) * this.getPos();
        }

        public double getPos() {
            return this.clamp ? Mth.m_14008_((double)this.pos, (double)0.0, (double)1.0) : this.pos;
        }

        public double getStart() {
            return this.start.get();
        }

        public double getEnd() {
            return this.end.get();
        }

        public Between clamp() {
            this.clamp = true;
            return this;
        }
    }

    public static class RelativeDynamic
    extends ConstraintImpl<RelativeDynamic> {
        protected final GeoRef relTo;
        protected final Supplier<Double> offset;

        public RelativeDynamic(GeoRef relTo, Supplier<Double> offset) {
            this.setAxis(relTo.parameter.axis);
            this.relTo = relTo;
            this.offset = offset;
        }

        @Override
        protected double getImpl() {
            return this.relTo.get() + this.getOffset();
        }

        public double getOffset() {
            return this.offset.get();
        }
    }

    public static class Relative
    extends ConstraintImpl<Relative> {
        protected final GeoRef relTo;
        protected final double offset;

        public Relative(GeoRef relTo, double offset) {
            this.setAxis(relTo.parameter.axis);
            this.relTo = relTo;
            this.offset = offset;
        }

        @Override
        protected double getImpl() {
            return this.relTo.get() + this.getOffset();
        }

        public double getOffset() {
            return this.offset;
        }
    }

    public static class Dynamic
    extends ConstraintImpl<Dynamic> {
        protected final Supplier<Double> value;

        public Dynamic(Supplier<Double> value) {
            this.value = value;
        }

        @Override
        protected double getImpl() {
            return this.value.get();
        }
    }

    public static class Literal
    extends ConstraintImpl<Literal> {
        protected final double value;

        public Literal(double value) {
            this.value = value;
        }

        @Override
        protected double getImpl() {
            return this.value;
        }
    }
}

