/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public interface TextState {
    public String getText();

    public void setText(String var1);

    public static TextState simpleState(String defaultValue) {
        return TextState.simpleState(defaultValue, null);
    }

    public static TextState simpleState(final String defaultValue, final @Nullable Consumer<String> changeListener) {
        return new TextState(){
            private String value;
            {
                this.value = defaultValue;
            }

            @Override
            public String getText() {
                return this.value;
            }

            @Override
            public void setText(String text) {
                this.value = text;
                if (changeListener != null) {
                    changeListener.accept(this.value);
                }
            }
        };
    }

    public static TextState create(final Supplier<String> getValue, final Consumer<String> setValue) {
        return new TextState(){

            @Override
            public String getText() {
                return (String)getValue.get();
            }

            @Override
            public void setText(String text) {
                setValue.accept(text);
            }
        };
    }
}

