/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen.recipe;

import codechicken.lib.datagen.recipe.FurnaceRecipeBuilder;
import codechicken.lib.datagen.recipe.RecipeBuilder;
import codechicken.lib.datagen.recipe.ShapedRecipeBuilder;
import codechicken.lib.datagen.recipe.ShapelessRecipeBuilder;
import codechicken.lib.datagen.recipe.SpecialCraftingRecipeBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class RecipeProvider
implements DataProvider {
    private final Map<ResourceLocation, RecipeBuilder> recipes = new HashMap<ResourceLocation, RecipeBuilder>();
    private final PackOutput output;
    protected final String modId;

    public RecipeProvider(PackOutput output, String modId) {
        this.output = output;
        this.modId = modId;
    }

    public final CompletableFuture<Void> m_213708_(CachedOutput cache) {
        Path path = this.output.m_245114_();
        this.registerRecipes();
        LinkedList<CompletableFuture> futures = new LinkedList<CompletableFuture>();
        for (Map.Entry<ResourceLocation, RecipeBuilder> entry : this.recipes.entrySet()) {
            ResourceLocation id = entry.getKey();
            FinishedRecipe finishedRecipe = entry.getValue().build();
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)finishedRecipe.m_125966_(), (Path)path.resolve("data/" + id.m_135827_() + "/recipes/" + id.m_135815_() + ".json")));
            JsonObject advancement = finishedRecipe.m_5860_();
            if (advancement == null) continue;
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)advancement, (Path)path.resolve("data/" + id.m_135827_() + "/advancements/" + id.m_135815_() + ".json")));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    protected abstract void registerRecipes();

    protected <T extends RecipeBuilder> T builder(T builder) {
        if (this.recipes.containsKey(builder.getId())) {
            throw new IllegalArgumentException("Recipe with id '" + builder.getId() + "' already exists.");
        }
        this.recipes.put(builder.getId(), builder);
        return builder;
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemLike result) {
        return this.builder(ShapedRecipeBuilder.builder(result, 1));
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemLike result, int count) {
        return this.builder(ShapedRecipeBuilder.builder(new ItemStack(result, count)));
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemLike result, int count, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.builder(new ItemStack(result, count), id));
    }

    protected ShapedRecipeBuilder shapedRecipe(Supplier<? extends ItemLike> result) {
        return this.builder(ShapedRecipeBuilder.builder(result.get(), 1));
    }

    protected ShapedRecipeBuilder shapedRecipe(Supplier<? extends ItemLike> result, int count) {
        return this.builder(ShapedRecipeBuilder.builder(new ItemStack(result.get(), count)));
    }

    protected ShapedRecipeBuilder shapedRecipe(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.builder(new ItemStack(result.get(), count), id));
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemStack result) {
        return this.builder(ShapedRecipeBuilder.builder(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_())));
    }

    protected ShapedRecipeBuilder shapedRecipe(ItemStack result, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.builder(result, id));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemLike result) {
        return this.builder(ShapelessRecipeBuilder.builder(result, 1));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemLike result, int count) {
        return this.builder(ShapelessRecipeBuilder.builder(new ItemStack(result, count)));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemLike result, int count, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.builder(new ItemStack(result, count), id));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(Supplier<? extends ItemLike> result) {
        return this.builder(ShapelessRecipeBuilder.builder(result.get(), 1));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(Supplier<? extends ItemLike> result, int count) {
        return this.builder(ShapelessRecipeBuilder.builder(new ItemStack(result.get(), count)));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.builder(new ItemStack(result.get(), count), id));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemStack result) {
        return this.builder(ShapelessRecipeBuilder.builder(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_())));
    }

    protected ShapelessRecipeBuilder shapelessRecipe(ItemStack result, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.builder(result, id));
    }

    protected FurnaceRecipeBuilder smelting(ItemLike result) {
        return this.builder(FurnaceRecipeBuilder.smelting(result, 1));
    }

    protected FurnaceRecipeBuilder smelting(ItemLike result, int count) {
        return this.builder(FurnaceRecipeBuilder.smelting(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder smelting(ItemLike result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smelting(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder smelting(Supplier<? extends ItemLike> result) {
        return this.builder(FurnaceRecipeBuilder.smelting(result.get(), 1));
    }

    protected FurnaceRecipeBuilder smelting(Supplier<? extends ItemLike> result, int count) {
        return this.builder(FurnaceRecipeBuilder.smelting(new ItemStack(result.get(), count)));
    }

    protected FurnaceRecipeBuilder smelting(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smelting(new ItemStack(result.get(), count), id));
    }

    protected FurnaceRecipeBuilder smelting(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.smelting(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_())));
    }

    protected FurnaceRecipeBuilder smelting(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smelting(result, id));
    }

    protected FurnaceRecipeBuilder blasting(ItemLike result) {
        return this.builder(FurnaceRecipeBuilder.blasting(result, 1));
    }

    protected FurnaceRecipeBuilder blasting(ItemLike result, int count) {
        return this.builder(FurnaceRecipeBuilder.blasting(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder blasting(ItemLike result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.blasting(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder blasting(Supplier<? extends ItemLike> result) {
        return this.builder(FurnaceRecipeBuilder.blasting(result.get(), 1));
    }

    protected FurnaceRecipeBuilder blasting(Supplier<? extends ItemLike> result, int count) {
        return this.builder(FurnaceRecipeBuilder.blasting(new ItemStack(result.get(), count)));
    }

    protected FurnaceRecipeBuilder blasting(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.blasting(new ItemStack(result.get(), count), id));
    }

    protected FurnaceRecipeBuilder blasting(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.blasting(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_())));
    }

    protected FurnaceRecipeBuilder blasting(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.blasting(result, id));
    }

    protected FurnaceRecipeBuilder smoking(ItemLike result) {
        return this.builder(FurnaceRecipeBuilder.smoking(result, 1));
    }

    protected FurnaceRecipeBuilder smoking(ItemLike result, int count) {
        return this.builder(FurnaceRecipeBuilder.smoking(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder smoking(ItemLike result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smoking(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder smoking(Supplier<? extends ItemLike> result) {
        return this.builder(FurnaceRecipeBuilder.smoking(result.get(), 1));
    }

    protected FurnaceRecipeBuilder smoking(Supplier<? extends ItemLike> result, int count) {
        return this.builder(FurnaceRecipeBuilder.smoking(new ItemStack(result.get(), count)));
    }

    protected FurnaceRecipeBuilder smoking(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smoking(new ItemStack(result.get(), count), id));
    }

    protected FurnaceRecipeBuilder smoking(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.smoking(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_())));
    }

    protected FurnaceRecipeBuilder smoking(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.smoking(result, id));
    }

    protected FurnaceRecipeBuilder campfire(ItemLike result) {
        return this.builder(FurnaceRecipeBuilder.campfire(result, 1));
    }

    protected FurnaceRecipeBuilder campfire(ItemLike result, int count) {
        return this.builder(FurnaceRecipeBuilder.campfire(new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder campfire(ItemLike result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.campfire(new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder campfire(Supplier<? extends ItemLike> result) {
        return this.builder(FurnaceRecipeBuilder.campfire(result.get(), 1));
    }

    protected FurnaceRecipeBuilder campfire(Supplier<? extends ItemLike> result, int count) {
        return this.builder(FurnaceRecipeBuilder.campfire(new ItemStack(result.get(), count)));
    }

    protected FurnaceRecipeBuilder campfire(Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.campfire(new ItemStack(result.get(), count), id));
    }

    protected FurnaceRecipeBuilder campfire(ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.campfire(result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_())));
    }

    protected FurnaceRecipeBuilder campfire(ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.campfire(result, id));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, ItemLike result) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, result, 1));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, ItemLike result, int count) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, new ItemStack(result, count)));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, ItemLike result, int count, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, new ItemStack(result, count), id));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, Supplier<? extends ItemLike> result) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, result.get(), 1));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, Supplier<? extends ItemLike> result, int count) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, new ItemStack(result.get(), count)));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, new ItemStack(result.get(), count), id));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, ItemStack result) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_())));
    }

    protected ShapedRecipeBuilder customShaped(RecipeSerializer<?> serializer, ItemStack result, ResourceLocation id) {
        return this.builder(ShapedRecipeBuilder.custom(serializer, result, id));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, ItemLike result) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, result, 1));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, ItemLike result, int count) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, new ItemStack(result, count)));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, ItemLike result, int count, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, new ItemStack(result, count), id));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, Supplier<? extends ItemLike> result) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, result.get(), 1));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, Supplier<? extends ItemLike> result, int count) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, new ItemStack(result.get(), count)));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, new ItemStack(result.get(), count), id));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, ItemStack result) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_())));
    }

    protected ShapelessRecipeBuilder customShapeless(RecipeSerializer<?> serializer, ItemStack result, ResourceLocation id) {
        return this.builder(ShapelessRecipeBuilder.custom(serializer, result, id));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, ItemLike result) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, result, 1));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, ItemLike result, int count) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, new ItemStack(result, count)));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, ItemLike result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, new ItemStack(result, count), id));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, Supplier<? extends ItemLike> result) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, result.get(), 1));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, Supplier<? extends ItemLike> result, int count) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, new ItemStack(result.get(), count)));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, Supplier<? extends ItemLike> result, int count, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, new ItemStack(result.get(), count), id));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, ItemStack result) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, result, ForgeRegistries.ITEMS.getKey((Object)result.m_41720_())));
    }

    protected FurnaceRecipeBuilder customFurnace(RecipeSerializer<?> serializer, ItemStack result, ResourceLocation id) {
        return this.builder(FurnaceRecipeBuilder.custom(serializer, result, id));
    }

    protected SpecialCraftingRecipeBuilder special(SimpleCraftingRecipeSerializer<?> serializer, String id) {
        return this.builder(SpecialCraftingRecipeBuilder.builder(serializer, id));
    }

    protected SpecialCraftingRecipeBuilder special(SimpleCraftingRecipeSerializer<?> serializer, ResourceLocation id) {
        return this.builder(SpecialCraftingRecipeBuilder.builder(serializer, id));
    }

    protected EnterBlockTrigger.TriggerInstance enteredBlock(Block blockIn) {
        return new EnterBlockTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, blockIn, StatePropertiesPredicate.f_67658_);
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(ItemLike itemIn) {
        return this.hasItem(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemIn}).m_45077_());
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(Supplier<? extends ItemLike> itemIn) {
        return this.hasItem(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{itemIn.get()}).m_45077_());
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(TagKey<Item> tagIn) {
        return this.hasItem(ItemPredicate.Builder.m_45068_().m_204145_(tagIn).m_45077_());
    }

    protected InventoryChangeTrigger.TriggerInstance hasItem(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }

    public String m_6055_() {
        return this.modId + " Recipes.";
    }
}

