/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen;

import codechicken.lib.datagen.recipe.ConditionBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import org.jetbrains.annotations.Nullable;

public class ConditionalIngredient
extends AbstractIngredient {
    private static final ResourceLocation TYPE = new ResourceLocation("codechickenlib", "conditional");
    private final List<ICondition> conditions;
    private final Ingredient pass;
    @Nullable
    private final Ingredient fail;

    private ConditionalIngredient(List<ICondition> conditions, Ingredient pass, @Nullable Ingredient fail) {
        this.conditions = conditions;
        this.pass = pass;
        this.fail = fail;
    }

    public static Builder builder() {
        return new Builder();
    }

    public JsonElement m_43942_() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", TYPE.toString());
        JsonArray conditions = new JsonArray();
        for (ICondition condition : this.conditions) {
            conditions.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
        }
        obj.add("conditions", (JsonElement)conditions);
        obj.add("pass", this.pass.m_43942_());
        if (this.fail != null) {
            obj.add("fail", this.fail.m_43942_());
        }
        return obj;
    }

    public ItemStack[] m_43908_() {
        throw new UnsupportedOperationException("Exists for DataGeneration only.");
    }

    public boolean isSimple() {
        throw new UnsupportedOperationException("Exists for DataGeneration only.");
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        throw new UnsupportedOperationException("Exists for DataGeneration only.");
    }

    public static class Builder {
        private List<ICondition> conditions = new LinkedList<ICondition>();
        private Ingredient pass = null;
        private Ingredient fail = null;

        private Builder() {
        }

        public Builder withCondition(Function<ConditionBuilder, ICondition> func) {
            this.conditions.add(func.apply(ConditionBuilder.INSTANCE));
            return this;
        }

        public Builder withPass(Ingredient ing) {
            if (this.pass != null) {
                throw new IllegalStateException("Pass Ingredient already specified.");
            }
            this.pass = ing;
            return this;
        }

        public Builder withFail(Ingredient ing) {
            if (this.fail != null) {
                throw new IllegalStateException("Pass Ingredient already specified.");
            }
            this.fail = ing;
            return this;
        }

        public ConditionalIngredient build() {
            if (this.conditions.isEmpty()) {
                throw new IllegalStateException("No conditions specified.");
            }
            if (this.pass == null) {
                throw new IllegalStateException("Pass Ingredient is required.");
            }
            return new ConditionalIngredient(this.conditions, this.pass, this.fail);
        }
    }

    public static class Serializer
    implements IIngredientSerializer<Ingredient> {
        private static final CrashLock LOCK = new CrashLock("Already Initialized");
        private static ICondition.IContext conditionContext = ICondition.IContext.EMPTY;

        public static void init() {
            LOCK.lock();
            MinecraftForge.EVENT_BUS.addListener(Serializer::onAddReloadListenerEvent);
            CraftingHelper.register((ResourceLocation)TYPE, (IIngredientSerializer)new Serializer());
        }

        private static void onAddReloadListenerEvent(AddReloadListenerEvent event) {
            conditionContext = event.getConditionContext();
        }

        public Ingredient parse(JsonObject json) {
            if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (ICondition.IContext)conditionContext)) {
                if (json.has("fail")) {
                    return CraftingHelper.getIngredient((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"fail"), (boolean)true);
                }
                return Ingredient.f_43901_;
            }
            return CraftingHelper.getIngredient((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"pass"), (boolean)false);
        }

        public Ingredient parse(FriendlyByteBuf buffer) {
            throw new UnsupportedOperationException();
        }

        public void write(FriendlyByteBuf buffer, Ingredient ingredient) {
            throw new UnsupportedOperationException();
        }
    }
}

