/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.block.component;

import codechicken.lib.block.component.PropertyComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class DirectionComponent
extends PropertyComponent<Direction> {
    public static PlacementFunc NONE = (state, ctx) -> null;
    public static PlacementFunc PLAYER_HORIZONTAL = (state, ctx) -> ctx.m_8125_();
    public static PlacementFunc PLAYER_LOOKING_NEAREST = (state, ctx) -> ctx.m_7820_().m_122424_();
    public static PlacementFunc FACE_NORMAL = (state, ctx) -> ctx.m_43719_();
    private final boolean horizontal;
    private PlacementFunc placementFunc;

    public DirectionComponent(boolean horizontal) {
        super(horizontal ? BlockStateProperties.f_61374_ : BlockStateProperties.f_61372_, Direction.NORTH);
        this.horizontal = horizontal;
        this.placementFunc = horizontal ? PLAYER_HORIZONTAL : PLAYER_LOOKING_NEAREST;
    }

    public DirectionComponent withPlacement(PlacementFunc func) {
        this.placementFunc = func;
        return this;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockState state, BlockPlaceContext ctx) {
        if (this.placementFunc == NONE) {
            return state;
        }
        Direction dir = this.placementFunc.apply(state, ctx);
        if (dir == null) {
            return state;
        }
        return (BlockState)state.m_61124_(this.property, (Comparable)dir);
    }

    @Override
    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation rotation) {
        return (BlockState)state.m_61124_(this.property, (Comparable)rotation.m_55954_((Direction)state.m_61143_(this.property)));
    }

    public static interface PlacementFunc {
        @Nullable
        public Direction apply(BlockState var1, BlockPlaceContext var2);
    }
}

