/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand.util;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.common.util.LazyOptional;
import snownee.lightingwand.CommonConfig;
import snownee.lightingwand.forge.EnergyRepair;

public interface PreventUpdateAnimation
extends IForgeItem {
    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    default public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        return new ICapabilityProvider(){
            private final LazyOptional<EnergyRepair> handler = LazyOptional.of(() -> new EnergyRepair(stack));

            public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                if (cap == ForgeCapabilities.ENERGY && CommonConfig.energyPerUse > 0) {
                    return this.handler.cast();
                }
                return LazyOptional.empty();
            }
        };
    }
}

