/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand;

import java.util.List;
import java.util.OptionalInt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import snownee.lightingwand.ColoredLightBlockEntity;
import snownee.lightingwand.CommonConfig;
import snownee.lightingwand.CoreModule;
import snownee.lightingwand.LightBlock;
import snownee.lightingwand.LightEntity;
import snownee.lightingwand.util.CommonProxy;

public class WandItem
extends Item
implements DyeableLeatherItem {
    public WandItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean isUsable(ItemStack stack) {
        return stack.m_41773_() < stack.m_41776_();
    }

    public static int getLightValue(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128425_("Light", 3)) {
            return Mth.m_14045_((int)stack.m_41783_().m_128451_("Light"), (int)1, (int)15);
        }
        return 15;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!WandItem.isUsable(stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!worldIn.f_46443_) {
            BlockHitResult rayTraceResult = WandItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos pos = rayTraceResult.m_82425_().m_121945_(rayTraceResult.m_82434_());
                if (!playerIn.m_36204_(pos, playerIn.m_6374_(), stack)) {
                    return new InteractionResultHolder(InteractionResult.FAIL, (Object)playerIn.m_21120_(handIn));
                }
                BlockState state = worldIn.m_8055_(pos);
                if (!CoreModule.isLightBlock(state) && state.m_247087_()) {
                    BlockEntity blockEntity;
                    worldIn.m_5594_(null, pos, SoundEvents.f_215682_, SoundSource.BLOCKS, 1.0f, playerIn.m_217043_().m_188501_() * 0.4f + 0.8f);
                    FluidState fluidstate = worldIn.m_6425_(pos);
                    OptionalInt color = this.getCustomColor(stack);
                    Block block = color.isEmpty() ? (Block)CoreModule.LIGHT.get() : (Block)CoreModule.COLORED_LIGHT.get();
                    worldIn.m_7731_(pos, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)LightBlock.LIGHT, (Comparable)Integer.valueOf(WandItem.getLightValue(stack)))).m_61124_((Property)LightBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8)), 11);
                    if (color.isPresent() && (blockEntity = worldIn.m_7702_(pos)) instanceof ColoredLightBlockEntity) {
                        ColoredLightBlockEntity be = (ColoredLightBlockEntity)blockEntity;
                        be.setColor(color.getAsInt());
                    }
                }
            } else if (rayTraceResult.m_6662_() == HitResult.Type.MISS && CommonConfig.shootProjectile) {
                worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_11877_, SoundSource.PLAYERS, 0.8f, 0.4f / (playerIn.m_217043_().m_188501_() * 0.4f + 0.8f));
                LightEntity entity = new LightEntity(worldIn, (LivingEntity)playerIn);
                entity.setLightValue(WandItem.getLightValue(stack));
                entity.setColor(this.getCustomColor(stack).orElse(0));
                entity.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), 0.0f, 1.5f, 0.0f);
                worldIn.m_7967_((Entity)entity);
            }
            stack.m_220157_(1, playerIn.m_217043_(), (ServerPlayer)playerIn);
            if (!WandItem.isUsable(stack)) {
                worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12018_, SoundSource.NEUTRAL, 0.5f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)worldIn.f_46443_);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        if (!context.m_7078_()) {
            return InteractionResult.PASS;
        }
        Level worldIn = context.m_43725_();
        BlockState state = worldIn.m_8055_(pos = context.m_8083_());
        if (!CoreModule.isLightBlock(state)) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        if (CoreModule.COLORED_LIGHT.is(state) && context.m_43724_() == InteractionHand.MAIN_HAND && player.m_21206_().m_150930_(Items.f_42027_)) {
            float alpha = 1.0f;
            if (stack.m_41782_() && stack.m_41784_().m_128441_("Alpha")) {
                alpha = stack.m_41783_().m_128457_("Alpha");
            }
            if (alpha > 0.91f) {
                alpha = 0.0f;
            }
            if ((alpha = Mth.m_14036_((float)(alpha + 0.1f), (float)0.0f, (float)1.0f)) == 1.0f) {
                stack.m_41749_("Alpha");
            } else {
                stack.m_41784_().m_128350_("Alpha", alpha);
            }
            BlockEntity blockEntity = worldIn.m_7702_(pos);
            if (blockEntity instanceof ColoredLightBlockEntity) {
                ColoredLightBlockEntity be = (ColoredLightBlockEntity)blockEntity;
                be.setColor(this.m_41121_(stack));
            }
            player.m_5661_((Component)Component.m_237110_((String)"tip.lightingwand.opacity", (Object[])new Object[]{(int)(alpha * 100.0f)}), true);
        } else {
            int blockLight;
            int wandLight = WandItem.getLightValue(stack);
            if (wandLight != (blockLight = ((Integer)state.m_61143_((Property)LightBlock.LIGHT)).intValue())) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)LightBlock.LIGHT, (Comparable)Integer.valueOf(wandLight)));
            } else {
                wandLight = wandLight % 15 + 1;
                stack.m_41784_().m_128405_("Light", wandLight);
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)LightBlock.LIGHT, (Comparable)Integer.valueOf(wandLight)));
                player.m_5661_((Component)Component.m_237110_((String)"tip.lightingwand.light", (Object[])new Object[]{wandLight}), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!WandItem.isUsable(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tip.lightingwand.uncharged").m_130940_(ChatFormatting.DARK_RED));
        }
        if (this.m_41113_(stack)) {
            if (CommonProxy.shimmerCompat) {
                tooltip.add((Component)Component.m_237110_((String)"tip.lightingwand.color", (Object[])new Object[]{Component.m_237113_((String)"\u25a0").m_130938_($ -> $.m_178520_(this.m_41121_(stack)))}).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tip.lightingwand.noShimmer").m_130940_(ChatFormatting.DARK_RED));
            }
        }
        tooltip.add((Component)Component.m_237110_((String)"tip.lightingwand.light", (Object[])new Object[]{WandItem.getLightValue(stack)}).m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_142522_(ItemStack stack) {
        if (!WandItem.isUsable(stack)) {
            return false;
        }
        return super.m_142522_(stack);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (WandItem.isUsable(stack)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200));
            if (attacker instanceof Player && !((Player)attacker).m_7500_()) {
                stack.m_41721_(stack.m_41773_() + 1);
            }
            return true;
        }
        return super.m_7579_(stack, target, attacker);
    }

    public boolean m_41113_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128425_("Color", 99);
    }

    public int m_41121_(ItemStack stack) {
        return this.getCustomColor(stack).orElse(CommonConfig.defaultLightColor);
    }

    public OptionalInt getCustomColor(ItemStack stack) {
        if (this.m_41113_(stack)) {
            float alpha = stack.m_41783_().m_128457_("Alpha");
            if (alpha == 0.0f) {
                alpha = 1.0f;
            }
            return OptionalInt.of(((int)(alpha * 255.0f) << 24) + stack.m_41783_().m_128451_("Color"));
        }
        return OptionalInt.empty();
    }

    public void m_41115_(ItemStack stack, int color) {
        stack.m_41784_().m_128405_("Color", color);
    }

    public void m_41123_(ItemStack stack) {
        stack.m_41749_("Color");
        stack.m_41749_("Alpha");
    }
}

