/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import snownee.lightingwand.CoreModule;
import snownee.lightingwand.WandItem;

public class RepairRecipe
extends CustomRecipe {
    private final String group;
    private final Item repairable;
    private final Ingredient material;
    private final int ratio;

    public RepairRecipe(ResourceLocation Id, String group, Item repairable, Ingredient material, int ratio) {
        super(Id, CraftingBookCategory.MISC);
        this.group = group;
        this.repairable = repairable;
        this.material = material;
        this.ratio = ratio;
        if (repairable.m_41462_() == 0) {
            throw new IllegalArgumentException(String.format("Recipe: %s, Item %s is not repairable", Id, repairable));
        }
    }

    public boolean m_8004_(int width, int height) {
        return width > 1 || height > 1;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        int dust = 0;
        ItemStack wand = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.m_41720_() == this.repairable && itemstack.m_41773_() != 0) {
                if (wand.m_41619_()) {
                    wand = itemstack;
                    continue;
                }
                return false;
            }
            if (!itemstack.m_41619_() && this.material.test(itemstack)) {
                ++dust;
                continue;
            }
            if (itemstack == ItemStack.f_41583_) continue;
            return false;
        }
        return !wand.m_41619_() && dust > 0 && wand.m_41773_() - Mth.m_14167_((float)(wand.m_41776_() / this.ratio)) * dust > -Mth.m_14167_((float)(wand.m_41776_() / this.ratio));
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        int dust = 0;
        ItemStack wand = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            int count;
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.m_150930_(this.repairable)) {
                wand = itemstack;
                continue;
            }
            if (itemstack.m_41619_() || !this.material.test(itemstack) || (count = itemstack.m_41613_()) <= 0) continue;
            ++dust;
        }
        int damage = Mth.m_14045_((int)(wand.m_41773_() - Mth.m_14167_((float)(wand.m_41776_() / this.ratio)) * dust), (int)0, (int)((WandItem)((Object)CoreModule.WAND.get())).m_41462_());
        ItemStack result = wand.m_41777_();
        result.m_41764_(1);
        result.m_41721_(damage);
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CoreModule.REPAIR.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public Ingredient getMaterial() {
        return this.material;
    }

    public Item getRepairable() {
        return this.repairable;
    }

    public int getRatio() {
        return this.ratio;
    }

    public static class Serializer
    implements RecipeSerializer<RepairRecipe> {
        public RepairRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            String s = GsonHelper.m_13906_((JsonObject)json, (String)"repairable");
            Item repairable = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s));
            if (repairable == Items.f_41852_) {
                throw new JsonSyntaxException("Unknown item '" + s + "'");
            }
            Ingredient material = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"material"));
            int ratio = GsonHelper.m_13927_((JsonObject)json, (String)"ratio");
            return new RepairRecipe(recipeId, group, repairable, material, ratio);
        }

        public RepairRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(256);
            Item repairable = Item.m_41445_((int)buffer.m_130242_());
            Ingredient material = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int ratio = buffer.m_130242_();
            return new RepairRecipe(recipeId, group, repairable, material, ratio);
        }

        public void toNetwork(FriendlyByteBuf buffer, RepairRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(Item.m_41393_((Item)recipe.repairable));
            recipe.material.m_43923_(buffer);
            buffer.m_130130_(recipe.ratio);
        }
    }
}

