/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import snownee.lightingwand.ColoredLightBlockEntity;
import snownee.lightingwand.CommonConfig;
import snownee.lightingwand.CoreModule;
import snownee.lightingwand.LightBlock;
import snownee.lightingwand.compat.ShimmerCompat;
import snownee.lightingwand.util.CommonProxy;

public class LightEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> DATA_LIGHT = SynchedEntityData.m_135353_(LightEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(LightEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public Object shimmerLight;
    private boolean discardNextTick;

    public LightEntity(EntityType<?> type, Level levelIn) {
        this(levelIn);
    }

    public LightEntity(Level levelIn) {
        super((EntityType)CoreModule.PROJECTILE.get(), levelIn);
    }

    public LightEntity(Level levelIn, LivingEntity owner) {
        super((EntityType)CoreModule.PROJECTILE.get(), owner, levelIn);
    }

    protected float m_7139_() {
        return 0.01f;
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        float f = Mth.m_14116_((float)((float)(x * x + y * y + z * z)));
        this.m_20334_(x / (double)f * (double)velocity, y / (double)f * (double)velocity, z / (double)f * (double)velocity);
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.placeLight(blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_()));
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        this.placeLight(BlockPos.m_274446_((Position)entityHitResult.m_82450_()));
    }

    private void placeLight(BlockPos pos) {
        Level level = this.m_9236_();
        if (this.discardNextTick || level.f_46443_ || !level.m_8055_(pos).m_247087_()) {
            return;
        }
        FluidState fluidstate = level.m_6425_(pos);
        int color = this.getColor();
        Block block = color == 0 ? (Block)CoreModule.LIGHT.get() : (Block)CoreModule.COLORED_LIGHT.get();
        if (level.m_7731_(pos, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)LightBlock.LIGHT, (Comparable)Integer.valueOf(Mth.m_14045_((int)this.getLightValue(), (int)1, (int)15)))).m_61124_((Property)LightBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8)), 11)) {
            BlockEntity blockEntity;
            if (color != 0 && (blockEntity = level.m_7702_(pos)) instanceof ColoredLightBlockEntity) {
                ColoredLightBlockEntity be = (ColoredLightBlockEntity)blockEntity;
                be.setColor(color);
            }
            level.m_5594_(null, pos, SoundEvents.f_215682_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.4f + 0.8f);
        }
        this.discardNextTick = true;
    }

    public void m_8119_() {
        if (this.discardNextTick) {
            this.m_146870_();
            return;
        }
        super.m_8119_();
        if (this.m_9236_().f_46443_ && !this.m_20096_()) {
            if (CommonProxy.shimmerCompat && this.shimmerLight == null) {
                ShimmerCompat.addLight(this);
            } else if (this.shimmerLight != null) {
                ShimmerCompat.updateLight(this);
            }
            Vec3 motion = this.m_20184_();
            Vector3f color = CommonConfig.intColorToVector3(this.getColor());
            for (int k = 0; k < 2; ++k) {
                this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), this.m_20185_() + motion.f_82479_ * (double)k / 2.0, this.m_20186_() + motion.f_82480_ * (double)k / 2.0, this.m_20189_() + motion.f_82481_ * (double)k / 2.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_LIGHT, (Object)15);
        this.f_19804_.m_135372_(DATA_COLOR, (Object)0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return CommonProxy.getAddEntityPacket(this);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setLightValue(compound.m_128451_("Light"));
        this.setColor(compound.m_128451_("Color"));
        this.discardNextTick = compound.m_128471_("Discard");
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Light", this.getLightValue());
        int color = this.getColor();
        if (color != 0) {
            compound.m_128405_("Color", color);
        }
        if (this.discardNextTick) {
            compound.m_128379_("Discard", true);
        }
    }

    public void m_142036_() {
        super.m_142036_();
        if (this.shimmerLight != null) {
            ShimmerCompat.removeLight(this);
        }
    }

    public int getLightValue() {
        return (Integer)this.f_19804_.m_135370_(DATA_LIGHT);
    }

    public void setLightValue(int lightValue) {
        if (lightValue == 0) {
            lightValue = 15;
        }
        this.f_19804_.m_135381_(DATA_LIGHT, (Object)lightValue);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR);
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)color);
    }
}

