/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import snownee.kiwi.block.ModBlock;
import snownee.kiwi.loader.Platform;
import snownee.lightingwand.ColoredLightBlockEntity;
import snownee.lightingwand.CommonConfig;
import snownee.lightingwand.CoreModule;
import snownee.lightingwand.util.ClientProxy;

public class LightBlock
extends ModBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty LIGHT = IntegerProperty.m_61631_((String)"light", (int)1, (int)15);

    public LightBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60918_(SoundType.f_222465_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(15)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return Platform.isPhysicalClient() && ClientProxy.hasItem() ? Shapes.m_83144_() : Shapes.m_83040_();
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return Shapes.m_83040_();
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (ClientProxy.hasItem()) {
            BlockEntity blockEntity;
            float x = (float)pos.m_123341_() + 0.3f + rand.m_188501_() * 0.4f;
            float y = (float)pos.m_123342_() + 0.5f;
            float z = (float)pos.m_123343_() + 0.3f + rand.m_188501_() * 0.4f;
            Vector3f colorVector = CommonConfig.defaultLightColorVector;
            if (CoreModule.COLORED_LIGHT.is(stateIn) && (blockEntity = worldIn.m_7702_(pos)) instanceof ColoredLightBlockEntity) {
                ColoredLightBlockEntity be = (ColoredLightBlockEntity)blockEntity;
                colorVector = CommonConfig.intColorToVector3(be.getColor());
            }
            worldIn.m_7106_((ParticleOptions)new DustParticleOptions(colorVector, 1.0f), (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        }
    }

    public int getColor(BlockState stateIn, Level worldIn, BlockPos pos) {
        return CommonConfig.defaultLightColor;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, LIGHT});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }
}

