/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand;

import java.util.function.Supplier;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.util.KiwiEntityTypeBuilder;
import snownee.lightingwand.ColoredLightBlock;
import snownee.lightingwand.ColoredLightBlockEntity;
import snownee.lightingwand.CommonConfig;
import snownee.lightingwand.LightBlock;
import snownee.lightingwand.LightEntity;
import snownee.lightingwand.RepairRecipe;
import snownee.lightingwand.WandItem;
import snownee.lightingwand.util.CommonProxy;

@KiwiModule
public class CoreModule
extends AbstractModule {
    @KiwiModule.NoItem
    public static final KiwiGO<Block> LIGHT = CoreModule.go(() -> new LightBlock(CoreModule.blockProp().m_280170_().m_60910_().m_222994_().m_60966_().m_246721_().m_60953_(state -> (Integer)state.m_61143_((Property)LightBlock.LIGHT))));
    @KiwiModule.NoItem
    public static final KiwiGO<Block> COLORED_LIGHT = CoreModule.go(() -> new ColoredLightBlock(CommonProxy.shimmerCompat ? CoreModule.blockProp((BlockBehaviour)((BlockBehaviour)LIGHT.getOrCreate())).m_60953_($ -> 0) : CoreModule.blockProp((BlockBehaviour)((BlockBehaviour)LIGHT.getOrCreate()))));
    @KiwiModule.Category(value={"tools"})
    public static final KiwiGO<WandItem> WAND = CoreModule.go(() -> new WandItem(CoreModule.itemProp().m_41503_(CommonConfig.wandDurability)));
    public static final KiwiGO<RecipeSerializer<RepairRecipe>> REPAIR = CoreModule.go(RepairRecipe.Serializer::new);
    @KiwiModule.Name(value="light")
    public static final KiwiGO<BlockEntityType<ColoredLightBlockEntity>> LIGHT_TILE = CoreModule.blockEntity(ColoredLightBlockEntity::new, null, (Supplier[])new Supplier[]{COLORED_LIGHT});
    @KiwiModule.Name(value="light")
    public static final KiwiGO<EntityType<LightEntity>> PROJECTILE = CoreModule.go(() -> KiwiEntityTypeBuilder.create().entityFactory((spawnEntity, world) -> new LightEntity(world)).fireImmune().trackRangeChunks(4).trackedUpdateRate(20).forceTrackedVelocityUpdates(true).build());

    public static boolean isLightBlock(BlockState state) {
        return LIGHT.is(state) || COLORED_LIGHT.is(state);
    }

    protected void init(InitEvent event) {
        event.enqueueWork(() -> {
            if (CommonConfig.shootProjectile) {
                DispenserBlock.m_52672_((ItemLike)((ItemLike)WAND.get()), (source, stack) -> {
                    ServerLevel world = source.m_7727_();
                    if (!world.f_46443_ && WandItem.isUsable(stack)) {
                        Position iposition = DispenserBlock.m_52720_((BlockSource)source);
                        Direction Direction2 = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                        LightEntity entity = new LightEntity((Level)world);
                        entity.m_6034_(iposition.m_7096_(), iposition.m_7098_(), iposition.m_7094_());
                        entity.setLightValue(WandItem.getLightValue(stack));
                        entity.setColor(((WandItem)((Object)((Object)((Object)WAND.get())))).getCustomColor(stack).orElse(0));
                        entity.m_6686_(Direction2.m_122429_(), (float)Direction2.m_122430_() + 0.1f, Direction2.m_122431_(), 1.3f + world.f_46441_.m_188501_() * 0.4f, 0.0f);
                        Vec3 motion = entity.m_20184_();
                        entity.m_20256_(motion.m_82520_(world.f_46441_.m_188583_() * 0.1, 0.0, world.f_46441_.m_188583_() * 0.1));
                        world.m_7967_((Entity)entity);
                        stack.m_220157_(1, world.f_46441_, null);
                    }
                    return stack;
                });
            }
            CauldronInteraction.f_175607_.put((Item)WAND.get(), CauldronInteraction.f_175615_);
            CommonProxy.postRegister();
        });
    }
}

