/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferErrorWrapped;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public class JEIRecipeTransferHandler<C extends AbstractContainerMenu, R>
implements IRecipeTransferHandler<C, R> {
    private final IRecipeTransferHandlerHelper helper;
    private final IRecipeTransferInfo<C, R> info;
    private final TransferHandler handler;

    public JEIRecipeTransferHandler(IRecipeTransferHandlerHelper helper, IRecipeTransferInfo<C, R> info) {
        this.helper = helper;
        this.info = info;
        try {
            this.handler = (TransferHandler)Class.forName("me.shedaniel.rei.plugin.autocrafting.DefaultCategoryHandler").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<? extends C> getContainerClass() {
        return this.info.getContainerClass();
    }

    @Override
    public Optional<MenuType<C>> getMenuType() {
        return this.info.getMenuType();
    }

    @Override
    public RecipeType<R> getRecipeType() {
        return this.info.getRecipeType();
    }

    @Override
    @Nullable
    public IRecipeTransferError transferRecipe(C container, R recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        AbstractContainerScreen containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
        if (containerScreen == null) {
            return this.helper.createInternalError();
        }
        if (containerScreen.m_6262_() != container) {
            return this.helper.createInternalError();
        }
        TransferHandler.Context context = TransferHandler.Context.create((boolean)doTransfer, (boolean)maxTransfer, (AbstractContainerScreen)containerScreen, (Display)JEIPluginDetector.asDisplay(recipe));
        TransferHandler.Result result = this.handler.handle(context);
        if (result.isSuccessful()) {
            return null;
        }
        return new JEIRecipeTransferErrorWrapped(result);
    }
}

