/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import dev.architectury.fluid.FluidStack;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.wrap.JEIEntryDefinition;
import me.shedaniel.rei.jeicompat.wrap.JEIFocusGroup;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayoutBuilder;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeSlot;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeTransferRegistration;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;

public class JEIDisplaySetup {
    public static <T> Result create(IRecipeCategory<T> category, JEIWrappedDisplay<T> display, IFocusGroup focuses) {
        Result result = new Result();
        JEIRecipeLayoutBuilder builder = new JEIRecipeLayoutBuilder(result.shapelessData);
        category.setRecipe(builder, display.getBackingRecipe(), focuses);
        result.setSlots(builder.slots);
        return result;
    }

    public static void addTo(List<Widget> widgets, Rectangle bounds, Result result) {
        for (JEIRecipeSlot slot : result.slots) {
            RecipeIngredientRole role;
            if (!slot.isVisible()) continue;
            slot.slot.getBounds().translate(bounds.x + 4, bounds.y + 4);
            slot.slot.highlightEnabled(!slot.isEmpty());
            if (slot.background != null) {
                widgets.add(slot.background);
            }
            if ((role = slot.role) == RecipeIngredientRole.INPUT) {
                slot.slot.markInput();
            } else if (role == RecipeIngredientRole.OUTPUT) {
                slot.slot.markOutput();
            }
            widgets.add((Widget)Widgets.withTranslate((Widget)slot.slot, (double)0.0, (double)0.0, (double)10.0));
            for (Map.Entry<EntryType<?>, IIngredientRenderer<?>> rendererEntry : slot.renderers.entrySet()) {
                EntryType<?> type = rendererEntry.getKey();
                JEIEntryDefinition.Renderer renderer = new JEIEntryDefinition.Renderer(rendererEntry.getValue());
                for (EntryStack entry : slot.slot.getEntries()) {
                    if (entry.getType() != type) continue;
                    ClientEntryStacks.setRenderer((EntryStack)entry, renderer);
                }
            }
            if (slot.renderers.size() == 1) {
                IIngredientRenderer<?> renderer = slot.renderers.values().iterator().next();
                slot.slot.getBounds().setSize(renderer.getWidth() + 2, renderer.getHeight() + 2);
            }
            if (slot.capacityMb != null) {
                for (EntryStack entry : slot.slot.getEntries()) {
                    if (entry.getType() != VanillaEntryTypes.FLUID) continue;
                    ClientEntryStacks.setFluidRenderRatio((EntryStack)entry.cast(), (float)((float)((FluidStack)entry.cast().getValue()).getAmount() / (float)slot.capacityMb.longValue()));
                }
            }
            for (EntryStack entry : slot.slot.getEntries()) {
                if (entry.getType() != VanillaEntryTypes.FLUID) continue;
                entry.setting(EntryStack.Settings.FLUID_AMOUNT_VISIBLE, (Object)(slot.capacityMb != null && slot.renderers.get(VanillaEntryTypes.FLUID) == null ? 1 : 0));
            }
            if (slot.overlay != null) {
                widgets.add(slot.overlay);
            }
            for (EntryStack entry : slot.slot.getEntries()) {
                ClientEntryStacks.setTooltipProcessor((EntryStack)entry, (stack, tooltip) -> {
                    Object ingredient = null;
                    List components = CollectionUtils.filterAndMap((Iterable)tooltip.entries(), Tooltip.Entry::isText, Tooltip.Entry::getAsText);
                    slot.tooltipCallback.onTooltip(slot, components);
                    tooltip.entries().removeIf(Tooltip.Entry::isText);
                    tooltip.addAllTexts((Iterable)components);
                    return tooltip;
                });
            }
        }
    }

    public static class Result
    implements IRecipeSlotsView {
        public ShapelessData shapelessData = new ShapelessData();
        public List<JEIRecipeSlot> slots;
        public Map<RecipeIngredientRole, List<JEIRecipeSlot>> slotsRoled;

        public static Result fromREI(Display display) {
            DisplayCategory category = CategoryRegistry.getInstance().get(display.getCategoryIdentifier().cast()).getCategory();
            DisplayCategoryView categoryView = CategoryRegistry.getInstance().get(display.getCategoryIdentifier().cast()).getView(display);
            return Result.fromREI(display, (DisplayCategory<Display>)category, (DisplayCategoryView<Display>)categoryView);
        }

        public static Result fromREI(Display display, DisplayCategory<Display> category, DisplayCategoryView<Display> lastView) {
            if (display instanceof JEIWrappedDisplay) {
                return Result.fromREI(display, null);
            }
            return Result.fromREI(display, lastView.setupDisplay(display, new Rectangle(0, 0, category.getDisplayWidth(display), category.getDisplayHeight())));
        }

        public static Result fromREI(Display display, List<Widget> widgets) {
            if (display instanceof JEIWrappedDisplay) {
                JEIWrappedCategory wrappedCategory = ((JEIWrappedDisplay)display).getBackingCategory();
                return JEIDisplaySetup.create(wrappedCategory.getBackingCategory(), (JEIWrappedDisplay)display, JEIFocusGroup.EMPTY);
            }
            return Result.fromWidgets(widgets);
        }

        public static Result fromWidgets(List<Widget> widgets) {
            Result view = new Result();
            JEIRecipeLayoutBuilder builder = new JEIRecipeLayoutBuilder(null);
            JEIRecipeTransferRegistration.addToLayout(builder, widgets, 4, 4);
            view.setSlots(builder.slots);
            return view;
        }

        @Override
        public List<IRecipeSlotView> getSlotViews() {
            return this.slots;
        }

        @Override
        public List<IRecipeSlotView> getSlotViews(RecipeIngredientRole role) {
            return this.slotsRoled.getOrDefault((Object)role, Collections.emptyList());
        }

        @Override
        public Optional<IRecipeSlotView> findSlotByName(String slotName) {
            return this.slots.stream().filter(slot -> Objects.equals(slot.getSlotName().orElse(null), slotName)).findFirst();
        }

        public void setSlots(List<JEIRecipeSlot> slots) {
            this.slots = slots;
            this.slotsRoled = slots.stream().collect(Collectors.groupingBy(JEIRecipeSlot::getRole));
        }
    }

    public static class ShapelessData {
        public boolean shapeless;
        public Point pos;
    }
}

