/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.world.state;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import xaero.common.HudMod;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.container.MinimapWorldContainer;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.minimap.world.state.MinimapWorldState;
import xaero.hud.path.XaeroPath;

public class MinimapWorldStateUpdater {
    public static final int ROOT_CONTAINER_FORMAT = 2;
    private final HudMod modMain;
    private BlockPos currentWorldSpawn;

    public MinimapWorldStateUpdater(HudMod modMain) {
        this.modMain = modMain;
    }

    public void init(MinimapSession session, ClientPacketListener connection) {
        session.getWorldState().setAutoRootContainerPath(this.getAutoRootContainerPath(2, connection, session));
        for (int i = 0; i < 2; ++i) {
            session.getWorldState().setOutdatedAutoRootContainerPath(i, this.getAutoRootContainerPath(i, connection, session));
        }
    }

    public void update(MinimapSession session) {
        MinimapWorldState state = session.getWorldState();
        XaeroPath oldAutoWorldPath = state.getAutoWorldPath();
        XaeroPath potentialAutoContainerPath = this.getPotentialContainerPath(session);
        state.setAutoContainerPathIgnoreCaseCache(potentialAutoContainerPath);
        boolean worldmap = this.modMain.getSupportMods().worldmap();
        String potentialAutoWorldNode = this.getPotentialWorldNode((ResourceKey<Level>)session.getMc().f_91073_.m_46472_(), worldmap, session);
        if (potentialAutoWorldNode == null) {
            return;
        }
        XaeroPath autoWorldPath = potentialAutoContainerPath.resolve(potentialAutoWorldNode);
        state.setAutoWorldPath(autoWorldPath);
        if (oldAutoWorldPath != null && potentialAutoContainerPath.equals(oldAutoWorldPath.getParent())) {
            return;
        }
        MinimapWorldRootContainer autoRootContainer = session.getWorldManager().getAutoRootContainer();
        autoRootContainer.renameOldContainer(potentialAutoContainerPath);
        autoRootContainer.updateDimensionType(session.getMc().f_91073_);
        if (oldAutoWorldPath == null) {
            return;
        }
        MinimapWorldContainer oldContainer = session.getWorldManager().getWorldContainer(oldAutoWorldPath.getParent());
        oldContainer.getServerWaypointManager().clear();
    }

    public XaeroPath getPotentialContainerPath(MinimapSession session) {
        String dimensionNode = session.getDimensionHelper().getDimensionDirectoryName((ResourceKey<Level>)session.getMc().f_91073_.m_46472_());
        XaeroPath potentialContainerPath = session.getWorldState().getAutoRootContainerPath().resolve(dimensionNode);
        return this.ignoreContainerCase(potentialContainerPath, session.getWorldState().getAutoContainerPathIgnoreCaseCache(), session);
    }

    public XaeroPath ignoreContainerCase(XaeroPath potentialContainerPath, XaeroPath currentPath, MinimapSession session) {
        if (potentialContainerPath.equals(currentPath)) {
            return currentPath;
        }
        for (MinimapWorldRootContainer rootContainer : session.getWorldManager().getRootContainers()) {
            XaeroPath containerSearch = rootContainer.fixPathCharacterCases(potentialContainerPath);
            if (containerSearch == null) continue;
            return containerSearch;
        }
        return potentialContainerPath;
    }

    public XaeroPath getAutoRootContainerPath(int version, ClientPacketListener connection, MinimapSession session) {
        Object potentialContainerID;
        ServerData serverData = connection.m_245416_();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91092_() != null) {
            potentialContainerID = mc.m_91092_().m_129843_(LevelResource.f_78182_).getParent().getFileName().toString().replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
            if (version >= 2) {
                potentialContainerID = ((String)potentialContainerID).replace("[", "%lb%").replace("]", "%rb%");
            }
        } else if (mc.m_91294_() && this.modMain.getEvents().latestRealm != null) {
            potentialContainerID = "Realms_" + this.modMain.getEvents().latestRealm.f_87479_ + "." + this.modMain.getEvents().latestRealm.f_87473_;
        } else if (serverData != null) {
            String serverIP = this.modMain.getSettings().differentiateByServerAddress ? serverData.f_105363_ : "Any Address";
            int portDivider = version >= 1 && serverIP.indexOf(":") != serverIP.lastIndexOf(":") ? serverIP.lastIndexOf("]:") + 1 : serverIP.indexOf(":");
            if (portDivider > 0) {
                serverIP = serverIP.substring(0, portDivider);
            }
            while (serverIP.endsWith(".")) {
                serverIP = serverIP.substring(0, serverIP.length() - 1);
            }
            if (version >= 2) {
                serverIP = serverIP.replace("[", "").replace("]", "");
            }
            potentialContainerID = "Multiplayer_" + serverIP.replace(":", "\u00a7").replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
        } else {
            potentialContainerID = "Unknown";
        }
        XaeroPath potentialContainerPath = XaeroPath.root((String)potentialContainerID);
        potentialContainerPath = this.ignoreContainerCase(potentialContainerPath, null, session);
        return potentialContainerPath;
    }

    public String getPotentialWorldNode(ResourceKey<Level> dimId, boolean useWorldmap, MinimapSession session) {
        Object actualWorldNode;
        String worldmapWorldNode;
        if (session.getMc().m_91092_() != null) {
            return "waypoints";
        }
        MinimapWorldState state = session.getWorldState();
        MinimapWorldRootContainer rootContainer = session.getWorldManager().getRootWorldContainer(state.getAutoRootContainerPath());
        Object autoNodeBase = this.getAutoWorldNodeBase(rootContainer);
        if (autoNodeBase == null) {
            return null;
        }
        String string = worldmapWorldNode = useWorldmap ? this.modMain.getSupportMods().worldmapSupport.tryToGetMultiworldId(dimId) : null;
        if (useWorldmap && worldmapWorldNode == null) {
            return null;
        }
        if (autoNodeBase instanceof BlockPos) {
            BlockPos pos = (BlockPos)autoNodeBase;
            actualWorldNode = "mw" + (pos.m_123341_() >> 6) + "," + (pos.m_123342_() >> 6) + "," + (pos.m_123343_() >> 6);
            if (!rootContainer.isUsingMultiworldDetection()) {
                String defaultMultiworldId = rootContainer.getDefaultMultiworldId();
                if (defaultMultiworldId == null) {
                    rootContainer.setDefaultMultiworldId((String)actualWorldNode);
                    session.getWorldManagerIO().getRootConfigIO().save(rootContainer);
                } else {
                    actualWorldNode = defaultMultiworldId;
                }
            }
        } else {
            actualWorldNode = "mw$" + autoNodeBase;
        }
        if (useWorldmap && worldmapWorldNode != "minimap") {
            actualWorldNode = worldmapWorldNode;
        }
        return actualWorldNode;
    }

    public boolean hasServerLevelId(MinimapWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return worldData.serverLevelId != null && !rootContainer.isIgnoreServerLevelId();
    }

    public Object getAutoWorldNodeBase(MinimapWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return this.hasServerLevelId(rootContainer) ? worldData.serverLevelId : this.currentWorldSpawn;
    }

    public void onServerLevelId(int id) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        worldData.serverLevelId = id;
        MinimapLogs.LOGGER.info("Minimap updated server level id: " + id + " for world " + Minecraft.m_91087_().f_91073_.m_46472_());
    }

    public void setCurrentWorldSpawn(BlockPos currentWorldSpawn) {
        this.currentWorldSpawn = currentWorldSpawn;
    }
}

