/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.UnmodifiableIterator;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import cpw.mods.inventorysorter.ItemStackHolder;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.util.Supplier;

public enum SortingHandler implements Consumer<ContainerContext>
{
    INSTANCE;

    private static final ResourceLocation DUMMY_PLAYER_CONTAINER;

    @Override
    public void accept(ContainerContext context) {
        if (context == null) {
            throw new NullPointerException("WHUT");
        }
        if (context.slotMapping == null) {
            return;
        }
        Multiset<ItemStackHolder> itemcounts = InventoryHandler.INSTANCE.getInventoryContent(context);
        if (context.slot.f_40218_ instanceof CraftingContainer) {
            this.distributeInventory(context, itemcounts);
        } else if (!context.slotMapping.markAsHeterogeneous) {
            this.compactInventory(context, itemcounts);
        }
    }

    private static ItemStack getStackInRowAndColumn(CraftingContainer inventory, int x, int y) {
        return inventory.m_8020_(y * inventory.m_39347_() + x);
    }

    private void distributeInventory(ContainerContext context, Multiset<ItemStackHolder> itemcounts) {
        ItemStackHolder ish;
        ItemStack is;
        int x;
        CraftingContainer ic = (CraftingContainer)context.slot.f_40218_;
        TreeMultiset slotCounts = TreeMultiset.create((Comparator)new InventoryHandler.ItemStackComparator());
        for (int x2 = 0; x2 < ic.m_39347_(); ++x2) {
            for (int y = 0; y < ic.m_39346_(); ++y) {
                ItemStack is2 = SortingHandler.getStackInRowAndColumn(ic, x2, y);
                if (is2.m_41619_()) continue;
                slotCounts.add((Object)new ItemStackHolder(is2));
            }
        }
        ImmutableMultiset staticcounts = ImmutableMultiset.copyOf(itemcounts);
        for (x = 0; x < ic.m_39347_(); ++x) {
            for (int y = 0; y < ic.m_39346_(); ++y) {
                is = SortingHandler.getStackInRowAndColumn(ic, x, y);
                if (is.m_41619_()) continue;
                ish = new ItemStackHolder(is);
                int count = staticcounts.count((Object)ish);
                int slotNum = slotCounts.count((Object)ish);
                int occurrences = count / slotNum;
                itemcounts.remove((Object)ish, occurrences);
                is.m_41764_(occurrences);
            }
        }
        for (x = 0; x < ic.m_39347_(); ++x) {
            for (int y = 0; y < ic.m_39346_(); ++y) {
                is = SortingHandler.getStackInRowAndColumn(ic, x, y);
                if (is.m_41619_() || itemcounts.count((Object)(ish = new ItemStackHolder(is))) <= 0) continue;
                is.m_41769_(itemcounts.setCount((Object)ish, 0));
            }
        }
        for (int slot = context.slotMapping.begin; slot < context.slotMapping.end + 1; ++slot) {
            context.player.f_36096_.m_38853_(slot).m_6654_();
        }
    }

    private void compactInventory(ContainerContext context, Multiset<ItemStackHolder> itemcounts) {
        UnmodifiableIterator itemsIterator;
        ResourceLocation containerTypeName;
        InventorySorter.INSTANCE.lastContainerType = containerTypeName = this.lookupContainerTypeName(context.slotMapping.container);
        if (InventorySorter.INSTANCE.isContainerBlacklisted(containerTypeName)) {
            InventorySorter.INSTANCE.debugLog("Container {} blacklisted", () -> new String[]{containerTypeName.toString()});
            return;
        }
        InventorySorter.INSTANCE.debugLog("Container \"{}\" being sorted", () -> new String[]{containerTypeName.toString()});
        try {
            itemsIterator = Multisets.copyHighestCountFirst(itemcounts).entrySet().iterator();
        }
        catch (Exception e) {
            InventorySorter.LOGGER.warn("Weird, the sorting didn't quite work!", (Throwable)e);
            return;
        }
        int slotLow = context.slotMapping.begin;
        int slotHigh = context.slotMapping.end + 1;
        Multiset.Entry stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
        int itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        for (int i = slotLow; i < slotHigh; ++i) {
            Slot slot = context.player.f_36096_.m_38853_(i);
            if (!slot.m_8010_((Player)context.player) && slot.m_6657_()) {
                InventorySorter.LOGGER.log(Level.DEBUG, "Slot {} of container {} disallows canTakeStack", new Supplier[]{() -> slot.f_40219_, () -> containerTypeName});
                continue;
            }
            slot.m_5852_(ItemStack.f_41583_);
            ItemStack target = ItemStack.f_41583_;
            if (itemCount > 0 && stackHolder != null) {
                target = ((ItemStackHolder)stackHolder.getElement()).is.m_41777_();
                target.m_41764_(Math.min(itemCount, slot.m_5866_(target)));
            }
            if (!target.m_41619_() && !slot.m_5857_(target)) {
                ItemStack trg = target;
                InventorySorter.LOGGER.log(Level.DEBUG, "Item {} is not valid in slot {} of container {}", new Supplier[]{() -> trg, () -> slot.f_40219_, () -> containerTypeName});
                continue;
            }
            slot.m_5852_(target.m_41619_() ? ItemStack.f_41583_ : target);
            if ((itemCount -= !target.m_41619_() ? target.m_41613_() : 0) != 0) continue;
            stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
            itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        }
    }

    private ResourceLocation lookupContainerTypeName(AbstractContainerMenu container) {
        return container instanceof InventoryMenu ? DUMMY_PLAYER_CONTAINER : ForgeRegistries.MENU_TYPES.getKey((Object)container.m_6772_());
    }

    static {
        DUMMY_PLAYER_CONTAINER = new ResourceLocation("inventorysorter:dummyplayercontainer");
    }
}

