/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.w2w2;

import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;
import xaero.minimap.XaeroMinimap;

public class WaystoneActivatedPacket {
    public static String invalid = "invalid";
    private BlockPos pos;
    private String name;

    public WaystoneActivatedPacket(BlockPos pos, String name) {
        this.pos = pos;
        this.name = name;
    }

    public static void handle(WaystoneActivatedPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> WaystoneActivatedPacket.lambda$handle$1(msg, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    private static void handlePacket(WaystoneActivatedPacket msg, Supplier<NetworkEvent.Context> ctx) {
        String name = msg.name;
        if (name.isEmpty()) {
            name = "Unnamed Waystone";
        }
        BlockPos pos = msg.pos;
        if (name.equals(invalid)) {
            return;
        }
        IXaeroMinimapClientPlayNetHandler clientLevel = (IXaeroMinimapClientPlayNetHandler)Minecraft.m_91087_().f_91074_.f_108617_;
        XaeroMinimapSession session = clientLevel.getXaero_minimapSession();
        WaypointsManager waypointsManager = session.getWaypointsManager();
        Waypoint instant = new Waypoint(pos.m_123341_(), pos.m_123342_() + 2, pos.m_123343_(), name, name.substring(0, 1), (int)(Math.random() * (double)ModSettings.ENCHANT_COLORS.length), 0, false);
        waypointsManager.getWaypoints().getList().add(instant);
        try {
            XaeroMinimap.instance.getSettings().saveWaypoints(waypointsManager.getCurrentWorld());
        }
        catch (IOException error) {
            error.printStackTrace();
        }
    }

    public static WaystoneActivatedPacket decode(FriendlyByteBuf packetBuffer) {
        BlockPos pos = packetBuffer.m_130135_();
        String name = packetBuffer.m_130277_();
        return new WaystoneActivatedPacket(pos, name);
    }

    public static void encode(WaystoneActivatedPacket msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130064_(msg.pos);
        packetBuffer.m_130070_(msg.name);
    }

    private static /* synthetic */ Runnable lambda$handle$1(WaystoneActivatedPacket msg, Supplier ctx) {
        return () -> WaystoneActivatedPacket.lambda$handle$0(msg, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handle$0(WaystoneActivatedPacket msg, Supplier ctx) {
        WaystoneActivatedPacket.handlePacket(msg, ctx);
    }
}

