/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DefaultSmithingDisplay
extends BasicDisplay {
    @Nullable
    private final SmithingRecipeType type;

    @ApiStatus.Experimental
    public DefaultSmithingDisplay(SmithingTransformRecipe recipe) {
        this((SmithingRecipe)recipe, List.of(EntryIngredients.ofIngredient(recipe.f_265949_), EntryIngredients.ofIngredient(recipe.f_265888_), EntryIngredients.ofIngredient(recipe.f_265907_)));
    }

    @Deprecated(forRemoval=true)
    public DefaultSmithingDisplay(SmithingTrimRecipe recipe) {
        this((SmithingRecipe)recipe, List.of(EntryIngredients.ofIngredient(recipe.f_265958_), EntryIngredients.ofIngredient(recipe.f_266040_), EntryIngredients.ofIngredient(recipe.f_266053_)));
    }

    @ApiStatus.Experimental
    public static List<DefaultSmithingDisplay> from(SmithingTrimRecipe recipe) {
        RegistryAccess registryAccess = BasicDisplay.registryAccess();
        ArrayList<DefaultSmithingDisplay> displays = new ArrayList<DefaultSmithingDisplay>();
        for (ItemStack templateItem : recipe.f_265958_.m_43908_()) {
            Holder.Reference trimPattern = TrimPatterns.m_266468_((RegistryAccess)registryAccess, (ItemStack)templateItem).orElse(null);
            if (trimPattern == null) continue;
            for (ItemStack additionStack : recipe.f_266053_.m_43908_()) {
                Holder.Reference trimMaterial = TrimMaterials.m_266539_((RegistryAccess)registryAccess, (ItemStack)additionStack).orElse(null);
                if (trimMaterial == null) continue;
                EntryIngredient baseIngredient = EntryIngredients.ofIngredient(recipe.f_266040_);
                EntryIngredient templateOutput = baseIngredient.isEmpty() ? EntryIngredient.empty() : DefaultSmithingDisplay.getTrimmingOutput(registryAccess, EntryStacks.of(templateItem), (EntryStack)baseIngredient.get(0), EntryStacks.of(additionStack));
                displays.add(new DefaultSmithingDisplay(List.of(EntryIngredients.of(templateItem), baseIngredient, EntryIngredients.of(additionStack)), List.of(templateOutput), SmithingRecipeType.TRIM, Optional.ofNullable(recipe.m_6423_())));
            }
        }
        return displays;
    }

    public DefaultSmithingDisplay(SmithingRecipe recipe, List<EntryIngredient> inputs) {
        this(inputs, List.of(EntryIngredients.of(recipe.m_8043_(BasicDisplay.registryAccess()))), Optional.ofNullable(recipe.m_6423_()));
    }

    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location) {
        this(inputs, outputs, null, location);
    }

    @ApiStatus.Experimental
    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, @Nullable SmithingRecipeType type, Optional<ResourceLocation> location) {
        super(inputs, outputs, location);
        this.type = type;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.SMITHING;
    }

    @ApiStatus.Experimental
    @Nullable
    public SmithingRecipeType getType() {
        return this.type;
    }

    public static BasicDisplay.Serializer<DefaultSmithingDisplay> serializer() {
        return BasicDisplay.Serializer.of((input, output, id, tag) -> {
            SmithingRecipeType type = tag.m_128441_("Type") ? SmithingRecipeType.valueOf(tag.m_128461_("Type")) : null;
            return new DefaultSmithingDisplay(input, output, type, id);
        }, (display, tag) -> {
            if (display.type != null) {
                tag.m_128359_("Type", display.type.name());
            }
        });
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static EntryIngredient getTrimmingOutput(RegistryAccess registryAccess, EntryStack<?> template, EntryStack<?> base, EntryStack<?> addition) {
        if (template.getType() != VanillaEntryTypes.ITEM || base.getType() != VanillaEntryTypes.ITEM || addition.getType() != VanillaEntryTypes.ITEM) {
            return EntryIngredient.empty();
        }
        ItemStack templateItem = (ItemStack)template.castValue();
        ItemStack baseItem = (ItemStack)base.castValue();
        ItemStack additionItem = (ItemStack)addition.castValue();
        Holder.Reference trimPattern = TrimPatterns.m_266468_((RegistryAccess)registryAccess, (ItemStack)templateItem).orElse(null);
        if (trimPattern == null) {
            return EntryIngredient.empty();
        }
        Holder.Reference trimMaterial = TrimMaterials.m_266539_((RegistryAccess)registryAccess, (ItemStack)additionItem).orElse(null);
        if (trimMaterial == null) {
            return EntryIngredient.empty();
        }
        ArmorTrim armorTrim = new ArmorTrim((Holder)trimMaterial, (Holder)trimPattern);
        Optional trim = ArmorTrim.m_266285_((RegistryAccess)registryAccess, (ItemStack)baseItem);
        if (trim.isPresent() && ((ArmorTrim)trim.get()).m_266357_((Holder)trimPattern, (Holder)trimMaterial)) {
            return EntryIngredient.empty();
        }
        ItemStack newItem = baseItem.m_41777_();
        newItem.m_41764_(1);
        if (ArmorTrim.m_266570_((RegistryAccess)registryAccess, (ItemStack)newItem, (ArmorTrim)armorTrim)) {
            return EntryIngredients.of(newItem);
        }
        return EntryIngredient.empty();
    }

    @ApiStatus.Experimental
    public static enum SmithingRecipeType {
        TRIM,
        TRANSFORM;

    }
}

