/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.BatchedEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.util.SpriteRenderer;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class FluidEntryDefinition
implements EntryDefinition<FluidStack>,
EntrySerializer<FluidStack> {
    private static final String FLUID_AMOUNT = Platform.isForge() ? "tooltip.rei.fluid_amount.forge" : "tooltip.rei.fluid_amount";
    @OnlyIn(value=Dist.CLIENT)
    private EntryRenderer<FluidStack> renderer;

    public FluidEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> Client.init(this));
    }

    @Override
    public Class<FluidStack> getValueType() {
        return FluidStack.class;
    }

    @Override
    public EntryType<FluidStack> getType() {
        return VanillaEntryTypes.FLUID;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public EntryRenderer<FluidStack> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier(EntryStack<FluidStack> entry, FluidStack value) {
        return BuiltInRegistries.f_257020_.m_7981_((Object)value.getFluid());
    }

    @Override
    public boolean isEmpty(EntryStack<FluidStack> entry, FluidStack value) {
        return value.isEmpty();
    }

    @Override
    public FluidStack copy(EntryStack<FluidStack> entry, FluidStack value) {
        return value.copy();
    }

    @Override
    public FluidStack normalize(EntryStack<FluidStack> entry, FluidStack value) {
        Fluid fluid = value.getFluid();
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowingFluid = (FlowingFluid)fluid;
            fluid = flowingFluid.m_5613_();
        }
        return FluidStack.create((Fluid)fluid, (long)FluidStack.bucketAmount(), (CompoundTag)value.getTag());
    }

    @Override
    public FluidStack wildcard(EntryStack<FluidStack> entry, FluidStack value) {
        Fluid fluid = value.getFluid();
        if (fluid instanceof FlowingFluid) {
            fluid = ((FlowingFluid)fluid).m_5613_();
        }
        return FluidStack.create((Fluid)fluid, (long)FluidStack.bucketAmount());
    }

    @Override
    @Nullable
    public ItemStack cheatsAs(EntryStack<FluidStack> entry, FluidStack value) {
        if (value.isEmpty()) {
            return ItemStack.f_41583_;
        }
        Item bucket = value.getFluid().m_6859_();
        if (bucket == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)bucket);
    }

    @Override
    @Nullable
    public FluidStack add(FluidStack o1, FluidStack o2) {
        return o1.copyWithAmount(o1.getAmount() + o2.getAmount());
    }

    @Override
    public long hash(EntryStack<FluidStack> entry, FluidStack value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + value.getFluid().hashCode();
        code = 31 * code + Long.hashCode(FluidComparatorRegistry.getInstance().hashOf(context, value));
        return code;
    }

    @Override
    public boolean equals(FluidStack o1, FluidStack o2, ComparisonContext context) {
        if (o1.getFluid() != o2.getFluid()) {
            return false;
        }
        return FluidComparatorRegistry.getInstance().hashOf(context, o1) == FluidComparatorRegistry.getInstance().hashOf(context, o2);
    }

    @Override
    @Nullable
    public EntrySerializer<FluidStack> getSerializer() {
        return this;
    }

    @Override
    public boolean supportSaving() {
        return true;
    }

    @Override
    public boolean supportReading() {
        return true;
    }

    @Override
    public boolean acceptsNull() {
        return false;
    }

    @Override
    public CompoundTag save(EntryStack<FluidStack> entry, FluidStack value) {
        return value.write(new CompoundTag());
    }

    @Override
    public FluidStack read(CompoundTag tag) {
        return FluidStack.read((CompoundTag)tag);
    }

    @Override
    public Component asFormattedText(EntryStack<FluidStack> entry, FluidStack value) {
        return value.getName();
    }

    @Override
    public Stream<? extends TagKey<?>> getTagsFor(EntryStack<FluidStack> entry, FluidStack value) {
        return value.getFluid().m_205069_().m_203616_();
    }

    @Override
    public void fillCrashReport(CrashReport report, CrashReportCategory category, EntryStack<FluidStack> entry) {
        EntryDefinition.super.fillCrashReport(report, category, entry);
        FluidStack stack = entry.getValue();
        category.m_128165_("Fluid Type", () -> String.valueOf(BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluid())));
        category.m_128165_("Fluid Amount", () -> String.valueOf(stack.getAmount()));
        category.m_128165_("Fluid NBT", () -> String.valueOf(stack.getTag()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(FluidEntryDefinition definition) {
            definition.renderer = new FluidEntryRenderer();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FluidEntryRenderer
    implements BatchedEntryRenderer<FluidStack, TextureAtlasSprite> {
        private static final Supplier<TextureAtlasSprite> MISSING_SPRITE = Suppliers.memoize(() -> {
            TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_);
            return atlas.m_118316_(MissingTextureAtlasSprite.m_118071_());
        });

        @Override
        public TextureAtlasSprite getExtraData(EntryStack<FluidStack> entry) {
            FluidStack stack = entry.getValue();
            if (stack.isEmpty()) {
                return null;
            }
            return FluidStackHooks.getStillTexture((FluidStack)stack);
        }

        private TextureAtlasSprite missingTexture() {
            return MISSING_SPRITE.get();
        }

        @Override
        public int getBatchIdentifier(EntryStack<FluidStack> entry, Rectangle bounds, TextureAtlasSprite extraData) {
            return 0;
        }

        @Override
        public void startBatch(EntryStack<FluidStack> entry, TextureAtlasSprite extraData, GuiGraphics graphics, float delta) {
        }

        @Override
        public void renderBase(EntryStack<FluidStack> entry, TextureAtlasSprite sprite, GuiGraphics graphics, MultiBufferSource.BufferSource immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            TextureAtlasSprite s = sprite == null ? this.missingTexture() : sprite;
            SpriteRenderer.beginPass().setup((MultiBufferSource)immediate, RenderType.m_110451_()).sprite(s).color(sprite == null ? 0xFFFFFF : FluidStackHooks.getColor((FluidStack)entry.getValue())).light(0xF000F0).overlay(OverlayTexture.f_118083_).alpha(255).normal(graphics.m_280168_().m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).position(graphics.m_280168_().m_85850_().m_252922_(), bounds.x, (float)bounds.getMaxY() - (float)bounds.height * Mth.m_14036_((float)entry.get(EntryStack.Settings.FLUID_RENDER_RATIO).floatValue(), (float)0.0f, (float)1.0f), bounds.getMaxX(), bounds.getMaxY(), 0.0f).next(s.m_247685_());
        }

        @Override
        public void afterBase(EntryStack<FluidStack> entry, TextureAtlasSprite extraData, GuiGraphics graphics, float delta) {
        }

        @Override
        public void renderOverlay(EntryStack<FluidStack> entry, TextureAtlasSprite extraData, GuiGraphics graphics, MultiBufferSource.BufferSource immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
        }

        @Override
        public void endBatch(EntryStack<FluidStack> entry, TextureAtlasSprite extraData, GuiGraphics graphics, float delta) {
        }

        @Override
        public void render(EntryStack<FluidStack> entry, GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            FluidStack stack = entry.getValue();
            if (stack.isEmpty()) {
                return;
            }
            TextureAtlasSprite sprite = FluidStackHooks.getStillTexture((FluidStack)stack);
            if (sprite == null) {
                return;
            }
            int color = FluidStackHooks.getColor((FluidStack)stack);
            MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
            SpriteRenderer.beginPass().setup((MultiBufferSource)immediate, RenderType.m_110451_()).sprite(sprite).color(color).light(0xF000F0).overlay(OverlayTexture.f_118083_).alpha(255).normal(graphics.m_280168_().m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).position(graphics.m_280168_().m_85850_().m_252922_(), bounds.x, (float)bounds.getMaxY() - (float)bounds.height * Mth.m_14036_((float)entry.get(EntryStack.Settings.FLUID_RENDER_RATIO).floatValue(), (float)0.0f, (float)1.0f), bounds.getMaxX(), bounds.getMaxY(), 0.0f).next(InventoryMenu.f_39692_);
            immediate.m_109911_();
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<FluidStack> entry, TooltipContext context) {
            String amountTooltip;
            if (entry.isEmpty()) {
                return null;
            }
            ArrayList toolTip = Lists.newArrayList((Object[])new Component[]{entry.asFormattedText()});
            long amount = entry.getValue().getAmount();
            if (amount >= 0L && entry.get(EntryStack.Settings.FLUID_AMOUNT_VISIBLE).booleanValue() && (amountTooltip = I18n.m_118938_((String)FLUID_AMOUNT, (Object[])new Object[]{entry.getValue().getAmount()})) != null) {
                toolTip.addAll(Stream.of(amountTooltip.split("\n")).map(Component::m_237113_).collect(Collectors.toList()));
            }
            if (Minecraft.m_91087_().f_91066_.f_92125_) {
                ResourceLocation fluidId = BuiltInRegistries.f_257020_.m_7981_((Object)entry.getValue().getFluid());
                toolTip.add(Component.m_237113_((String)fluidId.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            return Tooltip.create(toolTip);
        }
    }
}

