/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.util;

import java.util.Objects;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class HashedEntryStackWrapper {
    private final EntryStack<?> stack;
    private final long hash;
    private final int hashInt;

    public HashedEntryStackWrapper(EntryStack<?> stack) {
        this.stack = Objects.requireNonNull(stack);
        this.hash = EntryStacks.hashExact(stack);
        this.hashInt = Long.hashCode(this.hash);
    }

    public HashedEntryStackWrapper(EntryStack<?> stack, long hash) {
        this.stack = Objects.requireNonNull(stack);
        this.hash = hash;
        this.hashInt = Long.hashCode(this.hash);
    }

    public boolean equals(Object o) {
        return o instanceof HashedEntryStackWrapper && this.hash == ((HashedEntryStackWrapper)o).hash;
    }

    public int hashCode() {
        return this.hashInt;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public EntryStack<?> unwrap() {
        return this.stack;
    }

    public long hashExact() {
        return this.hash;
    }

    public HashedEntryStackWrapper normalize() {
        EntryStack<?> normalized = this.stack.normalize();
        long hashExact = EntryStacks.hashExact(normalized);
        if (hashExact == this.hash) {
            return this;
        }
        return new HashedEntryStackWrapper(normalized, hashExact);
    }
}

