/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.hint;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.hint.HintsContainerWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class HintWidget
extends WidgetWithBounds {
    private static final int MAX_WIDTH = 180;
    private static final int MAX_HEIGHT = 130;
    private final HintsContainerWidget parent;
    private final Rectangle bounds = new Rectangle();
    private final Rectangle okayBounds = new Rectangle();
    private final int margin;
    private final Supplier<Point> point;
    private final String uuid;
    private final Collection<? extends FormattedText> lines;
    private List<List<FormattedCharSequence>> wrapped;
    private final NumberAnimator<Double> scroll = ValueAnimator.ofDouble((double)0.0);
    private int contentHeight;

    public HintWidget(HintsContainerWidget parent, int margin, Supplier<Point> point, String uuid, Collection<? extends FormattedText> lines) {
        this.parent = parent;
        this.margin = margin;
        this.point = point;
        this.uuid = uuid;
        this.lines = lines;
        this.recalculateBounds();
    }

    void recalculateBounds() {
        int screenWidth = this.minecraft.m_91268_().m_85445_();
        int screenHeight = this.minecraft.m_91268_().m_85444_();
        int width = Mth.m_14045_((int)CollectionUtils.mapAndMax(this.lines, l -> CollectionUtils.max(this.font.m_92923_(l, 172), Comparator.comparingLong(value -> this.font.m_92724_(value) + 8)).map(value -> this.font.m_92724_(value) + 8).orElse(0), Comparator.naturalOrder()).orElse(0), (int)60, (int)180);
        Point point = this.point.get();
        int spaceLeft = Math.max(point.x - 4, 0);
        int spaceRight = Math.max(screenWidth - point.x - 4, 0);
        this.bounds.width = Math.min(width, Math.max(spaceLeft, spaceRight));
        this.bounds.x = spaceRight >= spaceLeft ? point.x + this.margin : point.x - this.margin - this.bounds.width;
        this.wrapped = CollectionUtils.map(this.lines, l -> this.font.m_92923_(l, this.bounds.width - 8));
        int height = 17;
        for (List<FormattedCharSequence> formattedCharSequences : this.wrapped) {
            height += formattedCharSequences.size() * 9;
            height += 2;
        }
        this.contentHeight = height - 9 - 2;
        this.bounds.height = Math.min(height, 130);
        this.bounds.y = Mth.m_14045_((int)(point.y + this.margin - this.bounds.height), (int)4, (int)(screenHeight - this.bounds.height - 4));
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int color1;
        this.scroll.setTarget(ScrollingContainer.handleBounceBack((double)((Double)this.scroll.target()), (double)(this.contentHeight - (this.bounds.height - 8 - 9) - 9), (float)delta, (double)0.08));
        this.scroll.update((double)delta);
        graphics.m_280168_().m_85836_();
        int background = -267386864;
        int color2 = color1 = 0x505000FF;
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        graphics.m_280120_(x, y - 1, x + width, y, 400, background, background);
        graphics.m_280120_(x, y + height, x + width, y + height + 1, 400, background, background);
        graphics.m_280120_(x, y, x + width, y + height, 400, background, background);
        graphics.m_280120_(x - 1, y, x, y + height, 400, background, background);
        graphics.m_280120_(x + width, y, x + width + 1, y + height, 400, background, background);
        graphics.m_280120_(x, y + 1, x + 1, y + height - 1, 400, color1, color2);
        graphics.m_280120_(x + width - 1, y + 1, x + width, y + height - 1, 400, color1, color2);
        graphics.m_280120_(x, y, x + width, y + 1, 400, color1, color1);
        graphics.m_280120_(x, y + height - 1, x + width, y + height, 400, color2, color2);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 450.0f);
        int lineY = y + 4;
        try (CloseableScissors scissors = Widget.scissor(graphics, new Rectangle(x + 4, y + 4, width - 8, height - 8 - 9 - 2));){
            for (List<FormattedCharSequence> block : this.wrapped) {
                for (FormattedCharSequence line : block) {
                    graphics.m_280648_(this.font, line, x + 4, lineY - this.scroll.intValue(), -1);
                    lineY += 9;
                }
                lineY += 2;
            }
        }
        MutableComponent okay = Component.m_237115_((String)"gui.ok");
        int okayWidth = this.font.m_92852_((FormattedText)okay);
        int midPoint = x + 4 + (width - 4) / 2;
        this.okayBounds.setBounds(midPoint - okayWidth / 2, lineY, okayWidth, 9);
        if (this.okayBounds.contains(mouseX, mouseY)) {
            okay = okay.m_130940_(ChatFormatting.UNDERLINE);
        }
        graphics.m_280430_(this.font, (Component)okay, this.okayBounds.x, this.okayBounds.y, -6710887);
        graphics.m_280168_().m_85849_();
        if (this.bounds.contains(mouseX, mouseY)) {
            ScreenOverlayImpl.getInstance().clearTooltips();
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return List.of();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.okayBounds.contains(mouseX, mouseY)) {
            this.parent.removeHint(this);
            Widgets.produceClickSound();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.scroll.setTo((Double)this.scroll.target() + ClothConfigInitializer.getScrollStep() * amount * ((double)this.getBounds().getWidth() / -50.0), ClothConfigInitializer.getScrollDuration());
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }
}

