/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public final class BurningFireWidget
extends BurningFire {
    private Rectangle bounds;
    private double animationDuration = -1.0;
    private final NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public BurningFireWidget(Rectangle bounds) {
        this.bounds = new Rectangle(Objects.requireNonNull(bounds));
    }

    @Override
    public double getAnimationDuration() {
        return this.animationDuration;
    }

    @Override
    public void setAnimationDuration(double animationDurationMS) {
        this.animationDuration = animationDurationMS;
        if (this.animationDuration <= 0.0) {
            this.animationDuration = -1.0;
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.darkBackgroundAlpha.update((double)delta);
        this.renderBackground(graphics, false, 1.0f);
        if (((Float)this.darkBackgroundAlpha.value()).floatValue() > 0.0f) {
            this.renderBackground(graphics, true, ((Float)this.darkBackgroundAlpha.value()).floatValue());
        }
    }

    public void renderBackground(GuiGraphics graphics, boolean dark, float alpha) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        ResourceLocation texture = REIRuntime.getInstance().getDefaultDisplayTexture(dark);
        if (this.getAnimationDuration() > 0.0) {
            int height = 14 - Mth.m_14165_((double)((double)System.currentTimeMillis() / (this.animationDuration / 14.0) % 14.0));
            graphics.m_280218_(texture, this.getX(), this.getY(), 1, 74, 14, 14 - height);
            graphics.m_280218_(texture, this.getX(), this.getY() + 14 - height, 82, 77 + (14 - height), 14, height);
        } else {
            graphics.m_280218_(texture, this.getX(), this.getY(), 1, 74, 14, 14);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }
}

