/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import dev.architectury.utils.value.IntValue;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.widget.DelegateWidgetWithTranslate;
import org.joml.Matrix4f;

public class ListWidget {
    public static <T> Builder<T> builderOf(Rectangle bounds, List<T> entries, ListCellRenderer<T> cellRenderer) {
        return new Builder<T>(bounds, entries, cellRenderer);
    }

    public static <T extends WidgetWithBounds> WidgetBuilder<T> builderOfWidgets(Rectangle bounds, List<T> entries) {
        return new WidgetBuilder<T>(bounds, entries);
    }

    public static <T> WidgetWithBounds create(Rectangle bounds, List<T> entries, IntValue selected, int gap, boolean calculateTotalHeightDynamically, ListCellRenderer<T> cellRenderer, ListEntryPredicate<T> isSelectable) {
        int[] i = new int[]{0};
        return ListWidget.create(bounds, CollectionUtils.map(entries, entry -> {
            int n = i[0];
            i[0] = n + 1;
            return cellRenderer.create(n, entry);
        }), selected, gap, calculateTotalHeightDynamically, (index, entry) -> isSelectable.test(index, entries.get(index)));
    }

    public static <T extends WidgetWithBounds> WidgetWithBounds create(Rectangle bounds, List<T> entries, IntValue selected, int gap, boolean calculateTotalHeightDynamically, ListEntryPredicate<T> isSelectable) {
        int[] height = new int[]{ListWidget.collectTotalHeight(entries, gap)};
        Rectangle innerBounds = bounds.clone();
        if (height[0] > bounds.getHeight()) {
            innerBounds.width -= 6;
        }
        int[] i = new int[]{0};
        List<CellWidget> wrapped = CollectionUtils.map(entries, cell -> {
            int n = i[0];
            i[0] = n + 1;
            return new CellWidget(innerBounds, n, (WidgetWithBounds)cell, selected, entries, isSelectable);
        });
        Widget update = Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> {
            if (calculateTotalHeightDynamically) {
                height[0] = ListWidget.collectTotalHeight(entries, gap);
                innerBounds.width = height[0] > bounds.getHeight() ? bounds.width - 6 : bounds.width;
            }
            int y = bounds.y;
            for (CellWidget cell : wrapped) {
                cell.position.move(bounds.x, y);
                y += (calculateTotalHeightDynamically ? cell.getBounds().getHeight() : cell.height) + gap;
            }
            if (selected.getAsInt() != -1) {
                CellWidget cellWidget = (CellWidget)wrapped.get(selected.getAsInt());
                int x1 = innerBounds.x;
                int x2 = innerBounds.getMaxX();
                boolean contains = new Rectangle(x1 - 1, cellWidget.position.y - 1, x2 - x1 + 2, cellWidget.getBounds().height + 2).contains(mouseX, mouseY);
                graphics.m_280509_(x1 - 1, cellWidget.position.y - 1, x2 + 1, cellWidget.position.y + cellWidget.getBounds().height + 1, contains ? -3092272 : -7368817);
                graphics.m_280509_(x1, cellWidget.position.y, x2, cellWidget.position.y + cellWidget.getBounds().height, -16777216);
            }
        });
        ArrayList<Widget> innerWidgets = new ArrayList<Widget>();
        innerWidgets.add(update);
        innerWidgets.addAll(wrapped);
        return Widgets.concatWithBounds(() -> new Rectangle(bounds.x, bounds.y, bounds.width, height[0]), innerWidgets);
    }

    private static int collectTotalHeight(List<? extends WidgetWithBounds> cells, int gap) {
        int height = Math.max(0, (cells.size() - 1) * gap);
        for (WidgetWithBounds widgetWithBounds : cells) {
            height += widgetWithBounds.getBounds().getHeight();
        }
        return height;
    }

    public static class Builder<T>
    extends AbstractBuilder<WidgetWithBounds, Builder<T>> {
        protected final List<T> entries;
        protected final ListCellRenderer<T> cellRenderer;
        protected ListEntryPredicate<T> isSelectable = (index, entry) -> false;

        protected Builder(Rectangle bounds, List<T> entries, ListCellRenderer<T> cellRenderer) {
            super(bounds);
            this.entries = entries;
            this.cellRenderer = cellRenderer;
        }

        public Builder<T> isSelectable(ListEntryPredicate<T> isSelectable) {
            this.isSelectable = isSelectable;
            return this;
        }

        @Override
        public WidgetWithBounds build() {
            return ListWidget.create(this.bounds, this.entries, this.selected, this.gap, this.calculateTotalHeightDynamically, this.cellRenderer, this.isSelectable);
        }
    }

    @FunctionalInterface
    public static interface ListCellRenderer<T> {
        public WidgetWithBounds create(int var1, T var2);
    }

    public static class WidgetBuilder<T extends WidgetWithBounds>
    extends AbstractBuilder<T, WidgetBuilder<T>> {
        protected final List<T> entries;
        protected ListEntryPredicate<T> isSelectable = (index, entry) -> false;

        protected WidgetBuilder(Rectangle bounds, List<T> entries) {
            super(bounds);
            this.entries = entries;
        }

        public WidgetBuilder<T> isSelectable(ListEntryPredicate<T> isSelectable) {
            this.isSelectable = isSelectable;
            return this;
        }

        @Override
        public WidgetWithBounds build() {
            return ListWidget.create(this.bounds, this.entries, this.selected, this.gap, this.calculateTotalHeightDynamically, this.isSelectable);
        }
    }

    @FunctionalInterface
    public static interface ListEntryPredicate<T> {
        public boolean test(int var1, T var2);
    }

    private static class CellWidget<T>
    extends DelegateWidgetWithTranslate {
        private final Rectangle bounds;
        private final int index;
        private final Point position = new Point();
        private final int height;
        private final IntValue selected;
        private final List<T> list;
        private final ListEntryPredicate<T> isSelectable;

        public CellWidget(Rectangle bounds, int index, WidgetWithBounds widget, IntValue selected, List<T> list, ListEntryPredicate<T> isSelectable) {
            super(widget, Matrix4f::new);
            this.bounds = bounds;
            this.index = index;
            this.height = widget.getBounds().getHeight();
            this.selected = selected;
            this.list = list;
            this.isSelectable = isSelectable;
        }

        @Override
        public WidgetWithBounds delegate() {
            return (WidgetWithBounds)super.delegate();
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            boolean clicked = super.m_6375_(mouseX, mouseY, button);
            Rectangle bounds = this.delegate().getBounds();
            if ((clicked || new Rectangle(this.position.x, this.position.y, this.bounds.width, bounds.height).contains(mouseX, mouseY)) && this.isSelectable.test(this.index, this.list.get(this.index))) {
                this.selected.accept(this.index);
                if (!clicked) {
                    Widgets.produceClickSound();
                }
                return true;
            }
            return clicked;
        }

        @Override
        protected Matrix4f translate() {
            Rectangle bounds = this.delegate().getBounds();
            return new Matrix4f().translate((float)(this.position.x - bounds.x), (float)(this.position.y - bounds.y), 0.0f);
        }
    }

    public static abstract class AbstractBuilder<T extends WidgetWithBounds, SELF extends AbstractBuilder<T, SELF>> {
        protected final Rectangle bounds;
        protected IntValue selected = new IntValue(){
            private int value = -1;

            public void accept(int i) {
                this.value = i;
            }

            public int getAsInt() {
                return this.value;
            }
        };
        protected int gap = 4;
        protected boolean calculateTotalHeightDynamically = false;

        protected AbstractBuilder(Rectangle bounds) {
            this.bounds = bounds;
        }

        public SELF selected(IntValue selected) {
            this.selected = selected;
            return (SELF)this;
        }

        public SELF selected(int selected) {
            this.selected.accept(selected);
            return (SELF)this;
        }

        public SELF gap(int gap) {
            this.gap = gap;
            return (SELF)this;
        }

        public SELF calculateTotalHeightDynamically(boolean calculateTotalHeightDynamically) {
            this.calculateTotalHeightDynamically = calculateTotalHeightDynamically;
            return (SELF)this;
        }

        public abstract WidgetWithBounds build();
    }
}

