/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.client.gui.AbstractContainerEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class DynamicErrorFreeEntryListWidget<E extends Entry<E>>
extends AbstractContainerEventHandler
implements Renderable,
NarratableEntry {
    protected static final int DRAG_OUTSIDE = -2;
    protected final Minecraft client;
    private final List<E> entries = new Entries();
    public int width;
    public int height;
    public int top;
    public int bottom;
    public int right;
    public int left;
    protected boolean verticallyCenter = true;
    protected int yDrag = -2;
    protected boolean selectionVisible = true;
    protected boolean renderSelection;
    protected int headerHeight;
    protected double scroll;
    protected boolean scrolling;
    @Nullable
    protected E hoveredItem;
    protected E selectedItem;
    protected ResourceLocation backgroundLocation;

    public DynamicErrorFreeEntryListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
        this.backgroundLocation = backgroundLocation;
    }

    public void setRenderSelection(boolean boolean_1) {
        this.selectionVisible = boolean_1;
    }

    protected void setRenderHeader(boolean boolean_1, int headerHeight) {
        this.renderSelection = boolean_1;
        this.headerHeight = headerHeight;
        if (!boolean_1) {
            this.headerHeight = 0;
        }
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        if (this.m_93696_()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.hoveredItem != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        E entry = this.hoveredItem;
        if (entry != null) {
            ((Entry)entry).updateNarration(narrationElementOutput.m_142047_());
            this.narrateListElementPosition(narrationElementOutput, entry);
        } else {
            E entry2 = this.getFocused();
            if (entry2 != null) {
                ((Entry)entry2).updateNarration(narrationElementOutput.m_142047_());
                this.narrateListElementPosition(narrationElementOutput, entry2);
            }
        }
        narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
    }

    protected void narrateListElementPosition(NarrationElementOutput narrationElementOutput, E entry) {
        int i;
        List<E> list = this.m_6702_();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            narrationElementOutput.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    public int getItemWidth() {
        return 220;
    }

    public E getSelectedItem() {
        return this.selectedItem;
    }

    public void selectItem(E item) {
        this.selectedItem = item;
    }

    public E getFocused() {
        return (E)((Entry)super.m_7222_());
    }

    public final List<E> m_6702_() {
        return this.entries;
    }

    protected final void clearItems() {
        this.entries.clear();
    }

    protected E getItem(int index) {
        return (E)((Entry)this.m_6702_().get(index));
    }

    protected int addItem(E item) {
        this.entries.add(item);
        return this.entries.size() - 1;
    }

    protected int getItemCount() {
        return this.m_6702_().size();
    }

    protected boolean isSelected(int index) {
        return Objects.equals(this.getSelectedItem(), this.m_6702_().get(index));
    }

    protected final E getItemAtPosition(double mouseX, double mouseY) {
        int listMiddleX = this.left + this.width / 2;
        int minX = listMiddleX - this.getItemWidth() / 2;
        int maxX = listMiddleX + this.getItemWidth() / 2;
        int currentY = Mth.m_14107_((double)(mouseY - (double)this.top)) - this.headerHeight + (int)this.getScroll() - 4;
        int itemY = 0;
        int itemIndex = -1;
        for (int i = 0; i < this.entries.size(); ++i) {
            E item = this.getItem(i);
            if ((itemY += ((Entry)item).getItemHeight()) <= currentY) continue;
            itemIndex = i;
            break;
        }
        return (E)(mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)minX && mouseX <= (double)maxX && itemIndex >= 0 && currentY >= 0 && itemIndex < this.getItemCount() ? (Entry)this.m_6702_().get(itemIndex) : null);
    }

    public void updateSize(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setLeftPos(int left) {
        this.left = left;
        this.right = left + this.width;
    }

    protected int getMaxScrollPosition() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = this.headerHeight;
        for (Entry entry : this.entries) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0);
    }

    protected void clickedHeader(int int_1, int int_2) {
    }

    protected void renderHeader(GuiGraphics graphics, int rowLeft, int startY, Tesselator tessellator) {
    }

    protected void drawBackground() {
    }

    protected void renderDecorations(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    @Deprecated
    protected void renderBackBackground(GuiGraphics graphics, BufferBuilder buffer, Tesselator tessellator) {
        DynamicErrorFreeEntryListWidget.renderBackBackground(graphics, buffer, tessellator, this.backgroundLocation, this.left, this.top, this.right, this.bottom, (int)this.getScroll(), 32);
    }

    public static void renderBackBackground(GuiGraphics graphics, BufferBuilder buffer, Tesselator tesselator, ResourceLocation backgroundLocation, int left, int top, int right, int bottom, int yOffset, int color) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)backgroundLocation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172820_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, (float)left, (float)bottom, 0.0f).m_7421_((float)left / 32.0f, (float)(bottom + yOffset) / 32.0f).m_6122_(color, color, color, 255).m_5752_();
        buffer.m_252986_(matrix, (float)right, (float)bottom, 0.0f).m_7421_((float)right / 32.0f, (float)(bottom + yOffset) / 32.0f).m_6122_(color, color, color, 255).m_5752_();
        buffer.m_252986_(matrix, (float)right, (float)top, 0.0f).m_7421_((float)right / 32.0f, (float)(top + yOffset) / 32.0f).m_6122_(color, color, color, 255).m_5752_();
        buffer.m_252986_(matrix, (float)left, (float)top, 0.0f).m_7421_((float)left / 32.0f, (float)(top + yOffset) / 32.0f).m_6122_(color, color, color, 255).m_5752_();
        tesselator.m_85914_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.drawBackground();
        int scrollbarPosition = this.getScrollbarPosition();
        int int_4 = scrollbarPosition + 6;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        this.renderBackBackground(graphics, buffer, tessellator);
        int rowLeft = this.getRowLeft();
        int startY = this.top + 4 - (int)this.getScroll();
        if (this.renderSelection) {
            this.renderHeader(graphics, rowLeft, startY, tessellator);
        }
        this.renderList(graphics, rowLeft, startY, mouseX, mouseY, delta);
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172817_);
        this.renderHoleBackground(graphics, 0, this.top, 255, 255);
        this.renderHoleBackground(graphics, this.bottom, this.height, 255, 255);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, (float)this.left, (float)(this.top + 4), 0.0f).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix, (float)this.right, (float)(this.top + 4), 0.0f).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix, (float)this.right, (float)this.top, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        buffer.m_252986_(matrix, (float)this.left, (float)this.top, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        buffer.m_252986_(matrix, (float)this.left, (float)this.bottom, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
        buffer.m_252986_(matrix, (float)this.right, (float)this.bottom, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
        buffer.m_252986_(matrix, (float)this.right, (float)(this.bottom - 4), 0.0f).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix, (float)this.left, (float)(this.bottom - 4), 0.0f).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        tessellator.m_85914_();
        int maxScroll = this.getMaxScroll();
        this.renderScrollBar(graphics, tessellator, buffer, maxScroll, scrollbarPosition, int_4);
        this.renderDecorations(graphics, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    protected void renderScrollBar(GuiGraphics graphics, Tesselator tessellator, BufferBuilder buffer, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (maxScroll > 0) {
            int int_9 = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            int_9 = Mth.m_14045_((int)int_9, (int)32, (int)(this.bottom - this.top - 8));
            int int_10 = (int)this.getScroll() * (this.bottom - this.top - int_9) / maxScroll + this.top;
            if (int_10 < this.top) {
                int_10 = this.top;
            }
            RenderSystem.setShader(GameRenderer::m_172811_);
            Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_252986_(matrix, (float)scrollbarPositionMinX, (float)this.bottom, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            buffer.m_252986_(matrix, (float)scrollbarPositionMaxX, (float)this.bottom, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            buffer.m_252986_(matrix, (float)scrollbarPositionMaxX, (float)this.top, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            buffer.m_252986_(matrix, (float)scrollbarPositionMinX, (float)this.top, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            buffer.m_252986_(matrix, (float)scrollbarPositionMinX, (float)(int_10 + int_9), 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            buffer.m_252986_(matrix, (float)scrollbarPositionMaxX, (float)(int_10 + int_9), 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            buffer.m_252986_(matrix, (float)scrollbarPositionMaxX, (float)int_10, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            buffer.m_252986_(matrix, (float)scrollbarPositionMinX, (float)int_10, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, (double)(int_10 + int_9 - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            buffer.m_5483_((double)(scrollbarPositionMaxX - 1), (double)(int_10 + int_9 - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            buffer.m_5483_((double)(scrollbarPositionMaxX - 1), (double)int_10, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            buffer.m_5483_((double)scrollbarPositionMinX, (double)int_10, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            tessellator.m_85914_();
        }
    }

    protected void centerScrollOn(E item) {
        double d = (double)(this.bottom - this.top) / -2.0;
        for (int i = 0; i < this.m_6702_().indexOf(item) && i < this.getItemCount(); ++i) {
            d += (double)((Entry)this.getItem(i)).getItemHeight();
        }
        this.capYPosition(d);
    }

    protected void ensureVisible(E item) {
        int int_3;
        int rowTop = this.getRowTop(this.m_6702_().indexOf(item));
        int int_2 = rowTop - this.top - 4 - ((Entry)item).getItemHeight();
        if (int_2 < 0) {
            this.scroll(int_2);
        }
        if ((int_3 = this.bottom - rowTop - ((Entry)item).getItemHeight() * 2) < 0) {
            this.scroll(-int_3);
        }
    }

    protected void scroll(int int_1) {
        this.capYPosition(this.getScroll() + (double)int_1);
        this.yDrag = -2;
    }

    public double getScroll() {
        return this.scroll;
    }

    public void capYPosition(double double_1) {
        this.scroll = Mth.m_14008_((double)double_1, (double)0.0, (double)this.getMaxScroll());
    }

    protected int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - (this.bottom - this.top - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScroll() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        this.scrolling = int_1 == 0 && double_1 >= (double)this.getScrollbarPosition() && double_1 < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    public boolean m_6375_(double double_1, double double_2, int int_1) {
        this.updateScrollingState(double_1, double_2, int_1);
        if (!this.m_5953_(double_1, double_2)) {
            return false;
        }
        E item = this.getItemAtPosition(double_1, double_2);
        if (item != null) {
            if (item.m_6375_(double_1, double_2, int_1)) {
                this.m_7522_((GuiEventListener)item);
                this.m_7897_(true);
                return true;
            }
        } else if (int_1 == 0) {
            this.clickedHeader((int)(double_1 - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(double_2 - (double)this.top) + (int)this.getScroll() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean m_6348_(double double_1, double double_2, int int_1) {
        if (this.getFocused() != null) {
            this.getFocused().m_6348_(double_1, double_2, int_1);
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.capYPosition(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = Mth.m_14045_((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(this.getScroll() + deltaY * double_6);
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double double_1, double double_2, double double_3) {
        for (Entry entry : this.entries) {
            if (!entry.m_6050_(double_1, double_2, double_3)) continue;
            return true;
        }
        this.capYPosition(this.getScroll() - double_3 * (double)(this.getMaxScroll() / this.getItemCount()) / 2.0);
        return true;
    }

    public boolean m_7933_(int int_1, int int_2, int int_3) {
        if (super.m_7933_(int_1, int_2, int_3)) {
            return true;
        }
        if (int_1 == 264) {
            this.moveSelection(1);
            return true;
        }
        if (int_1 == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int int_1) {
        if (!this.m_6702_().isEmpty()) {
            int int_2 = this.m_6702_().indexOf(this.getSelectedItem());
            int int_3 = Mth.m_14045_((int)(int_2 + int_1), (int)0, (int)(this.getItemCount() - 1));
            Entry itemListWidget$Item_1 = (Entry)this.m_6702_().get(int_3);
            this.selectItem(itemListWidget$Item_1);
            this.ensureVisible(itemListWidget$Item_1);
        }
    }

    public boolean m_5953_(double double_1, double double_2) {
        return double_2 >= (double)this.top && double_2 <= (double)this.bottom && double_1 >= (double)this.left && double_1 <= (double)this.right;
    }

    protected void renderList(GuiGraphics graphics, int startX, int startY, int int_3, int int_4, float float_1) {
        this.hoveredItem = this.m_5953_(int_3, int_4) ? this.getItemAtPosition(int_3, int_4) : null;
        int itemCount = this.getItemCount();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        for (int renderIndex = 0; renderIndex < itemCount; ++renderIndex) {
            E item = this.getItem(renderIndex);
            int itemY = startY + this.headerHeight;
            for (int i = 0; i < this.entries.size() && i < renderIndex; ++i) {
                itemY += ((Entry)this.entries.get(i)).getItemHeight();
            }
            int itemHeight = ((Entry)item).getItemHeight() - 4;
            int itemWidth = this.getItemWidth();
            if (this.selectionVisible && this.isSelected(renderIndex)) {
                int itemMinX = this.left + this.width / 2 - itemWidth / 2;
                int itemMaxX = itemMinX + itemWidth;
                float float_2 = this.m_93696_() ? 1.0f : 0.5f;
                Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShader(GameRenderer::m_172811_);
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                buffer.m_252986_(matrix, (float)itemMinX, (float)(itemY + itemHeight + 2), 0.0f).m_85950_(float_2, float_2, float_2, 1.0f).m_5752_();
                buffer.m_252986_(matrix, (float)itemMaxX, (float)(itemY + itemHeight + 2), 0.0f).m_85950_(float_2, float_2, float_2, 1.0f).m_5752_();
                buffer.m_252986_(matrix, (float)itemMaxX, (float)(itemY - 2), 0.0f).m_85950_(float_2, float_2, float_2, 1.0f).m_5752_();
                buffer.m_252986_(matrix, (float)itemMinX, (float)(itemY - 2), 0.0f).m_85950_(float_2, float_2, float_2, 1.0f).m_5752_();
                buffer.m_252986_(matrix, (float)(itemMinX + 1), (float)(itemY + itemHeight + 1), 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix, (float)(itemMaxX - 1), (float)(itemY + itemHeight + 1), 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix, (float)(itemMaxX - 1), (float)(itemY - 1), 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
                buffer.m_252986_(matrix, (float)(itemMinX + 1), (float)(itemY - 1), 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
                tessellator.m_85914_();
            }
            int y = this.getRowTop(renderIndex);
            int x = this.getRowLeft();
            this.renderItem(graphics, item, renderIndex, y, x, itemWidth, itemHeight, int_3, int_4, Objects.equals(this.hoveredItem, item), float_1);
        }
    }

    protected void renderItem(GuiGraphics graphics, E item, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        ((Entry)item).render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
    }

    protected int getRowLeft() {
        return this.left + this.width / 2 - this.getItemWidth() / 2 + 2;
    }

    protected int getRowTop(int index) {
        int integer = this.top + 4 - (int)this.getScroll() + this.headerHeight;
        for (int i = 0; i < this.entries.size() && i < index; ++i) {
            integer += ((Entry)this.entries.get(i)).getItemHeight();
        }
        return integer;
    }

    public boolean m_93696_() {
        return false;
    }

    protected void renderHoleBackground(GuiGraphics graphics, int y1, int y2, int alpha1, int alpha2) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.backgroundLocation);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172820_);
        float float_1 = 32.0f;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, (float)this.left, (float)y2, 0.0f).m_7421_(0.0f, (float)y2 / 32.0f).m_6122_(64, 64, 64, alpha2).m_5752_();
        buffer.m_252986_(matrix, (float)(this.left + this.width), (float)y2, 0.0f).m_7421_((float)this.width / 32.0f, (float)y2 / 32.0f).m_6122_(64, 64, 64, alpha2).m_5752_();
        buffer.m_252986_(matrix, (float)(this.left + this.width), (float)y1, 0.0f).m_7421_((float)this.width / 32.0f, (float)y1 / 32.0f).m_6122_(64, 64, 64, alpha1).m_5752_();
        buffer.m_252986_(matrix, (float)this.left, (float)y1, 0.0f).m_7421_(0.0f, (float)y1 / 32.0f).m_6122_(64, 64, 64, alpha1).m_5752_();
        tesselator.m_85914_();
    }

    protected E remove(int int_1) {
        Entry itemListWidget$Item_1 = (Entry)this.entries.get(int_1);
        return (E)(this.removeEntry((Entry)this.entries.get(int_1)) ? itemListWidget$Item_1 : null);
    }

    protected boolean removeEntry(E itemListWidget$Item_1) {
        boolean boolean_1 = this.entries.remove(itemListWidget$Item_1);
        if (boolean_1 && itemListWidget$Item_1 == this.getSelectedItem()) {
            this.selectItem(null);
        }
        return boolean_1;
    }

    @OnlyIn(value=Dist.CLIENT)
    class Entries
    extends AbstractList<E> {
        private final ArrayList<E> items = Lists.newArrayList();

        private Entries() {
        }

        @Override
        public void clear() {
            this.items.clear();
        }

        @Override
        public E get(int int_1) {
            return (Entry)this.items.get(int_1);
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public E set(int int_1, E itemListWidget$Item_1) {
            Entry itemListWidget$Item_2 = (Entry)this.items.set(int_1, itemListWidget$Item_1);
            ((Entry)itemListWidget$Item_1).parent = DynamicErrorFreeEntryListWidget.this;
            return itemListWidget$Item_2;
        }

        @Override
        public void add(int int_1, E itemListWidget$Item_1) {
            this.items.add(int_1, itemListWidget$Item_1);
            ((Entry)itemListWidget$Item_1).parent = DynamicErrorFreeEntryListWidget.this;
        }

        @Override
        public E remove(int int_1) {
            return (Entry)this.items.remove(int_1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry<E extends Entry<E>>
    implements GuiEventListener {
        @Deprecated
        DynamicErrorFreeEntryListWidget<E> parent;
        @Nullable
        private NarratableEntry lastNarratable;

        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public boolean m_5953_(double double_1, double double_2) {
            return Objects.equals(this.parent.getItemAtPosition(double_1, double_2), this);
        }

        public DynamicErrorFreeEntryListWidget<E> getParent() {
            return this.parent;
        }

        public void setParent(DynamicErrorFreeEntryListWidget<E> parent) {
            this.parent = parent;
        }

        public abstract int getItemHeight();

        @Deprecated
        public int getMorePossibleHeight() {
            return -1;
        }

        public abstract List<? extends NarratableEntry> narratables();

        void updateNarration(NarrationElementOutput narrationElementOutput) {
            List<NarratableEntry> list = this.narratables();
            Screen.NarratableSearchResult narratableSearchResult = Screen.m_169400_(list, (NarratableEntry)this.lastNarratable);
            if (narratableSearchResult != null) {
                if (narratableSearchResult.f_169422_.m_169123_()) {
                    this.lastNarratable = narratableSearchResult.f_169420_;
                }
                if (list.size() > 1) {
                    narrationElementOutput.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.object_list", (Object[])new Object[]{narratableSearchResult.f_169421_ + 1, list.size()}));
                    if (narratableSearchResult.f_169422_ == NarratableEntry.NarrationPriority.FOCUSED) {
                        narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
                    }
                }
                narratableSearchResult.f_169420_.m_142291_(narrationElementOutput.m_142047_());
            }
        }
    }

    public static final class SmoothScrollingSettings {
        public static final double CLAMP_EXTENSION = 200.0;

        private SmoothScrollingSettings() {
        }
    }
}

