/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.text;

import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import me.shedaniel.math.Color;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TextTransformations {
    public static FormattedCharSequence applyRainbow(FormattedCharSequence sequence, int x, int y) {
        int[] combinedX = new int[]{x};
        return sink -> sequence.m_13731_((charIndex, style, codePoint) -> {
            if (charIndex == 0) {
                combinedX[0] = x;
            }
            int rgb = Color.HSBtoRGB((float)((float)((Util.m_137550_() - (long)(combinedX[0] * 10) - (long)(y * 10)) % 2000L) / 2000.0f), (float)0.8f, (float)0.95f);
            combinedX[0] = (int)((float)combinedX[0] + Minecraft.m_91087_().f_91062_.m_92865_().f_92333_.m_92515_(codePoint, style));
            return sink.m_6411_(charIndex, style.m_131148_(TextColor.m_131266_((int)rgb)), codePoint);
        });
    }

    public static FormattedCharSequence forwardWithTransformation(String text, CharSequenceTransformer transformer) {
        if (text.isEmpty()) {
            return FormattedCharSequence.f_13691_;
        }
        return sink -> {
            int length = text.length();
            for (int charIndex = 0; charIndex < length; ++charIndex) {
                char c = text.charAt(charIndex);
                if (Character.isHighSurrogate(c)) {
                    if (charIndex + 1 >= length) {
                        if (sink.m_6411_(charIndex, Style.f_131099_, 65533)) break;
                        return false;
                    }
                    char forward = text.charAt(charIndex + 1);
                    if (Character.isLowSurrogate(forward)) {
                        if (!sink.m_6411_(charIndex, Style.f_131099_, Character.toCodePoint(c, forward))) {
                            return false;
                        }
                        ++charIndex;
                        continue;
                    }
                    if (sink.m_6411_(charIndex, Style.f_131099_, 65533)) continue;
                    return false;
                }
                if (!(Character.isSurrogate(c) ? !sink.m_6411_(charIndex, Style.f_131099_, 65533) : !sink.m_6411_(charIndex, transformer.apply(text, charIndex, c), (int)c))) continue;
                return false;
            }
            return true;
        };
    }

    public static MutableComponent highlightText(MutableComponent component, @Nullable String highlight, UnaryOperator<Style> styleOperator) {
        if (highlight == null) {
            return component.m_130938_(styleOperator);
        }
        String string = component.getString();
        if (string.toLowerCase(Locale.ROOT).equals(highlight.toLowerCase(Locale.ROOT))) {
            return component.m_130938_(styleOperator).m_130940_(ChatFormatting.YELLOW);
        }
        String[] parts = string.toLowerCase(Locale.ROOT).split(Pattern.quote(highlight.toLowerCase(Locale.ROOT)));
        if (string.toLowerCase(Locale.ROOT).endsWith(highlight.toLowerCase(Locale.ROOT))) {
            String[] newParts = new String[parts.length + 1];
            System.arraycopy(parts, 0, newParts, 0, parts.length);
            newParts[parts.length] = "";
            parts = newParts;
        }
        if (parts.length <= 1) {
            return component.m_130938_(styleOperator);
        }
        MutableComponent output = ConfigUtils.literal("");
        int curr = 0;
        for (int i = 0; i < parts.length; ++i) {
            output.m_7220_((Component)ConfigUtils.literal(string.substring(curr, curr + parts[i].length())).m_130938_(styleOperator));
            curr += parts[i].length();
            if (i == parts.length - 1) continue;
            output.m_7220_((Component)ConfigUtils.literal(string.substring(curr, curr + highlight.length())).m_130938_(styleOperator).m_130940_(ChatFormatting.YELLOW));
            curr += highlight.length();
        }
        return output;
    }

    @FunctionalInterface
    public static interface CharSequenceTransformer {
        public Style apply(String var1, int var2, char var3);
    }
}

