/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class CreativeItemGroup
extends CreativeModeTab {
    private final String modid;
    private final String identifier;
    private final ResourceLocation background;
    private Consumer<Consumer<ItemStack>> filler;
    private Comparator<ItemStack> sorter;
    private List<ItemStack> sortedDisplayItems;

    public static CreativeItemGroup create(String modid, String name, Supplier<ItemStack> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Item group name '" + name + "' must only contain characters [a-z0-9_.-]!");
        }
        String translationKey = modid + ".item_group." + name;
        return new CreativeItemGroup(modid, name, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, String name, ItemLike icon) {
        return CreativeItemGroup.create(modid, name, () -> icon.m_5456_().m_7968_());
    }

    public static CreativeItemGroup create(String modid, Supplier<ItemStack> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String translationKey = modid + ".item_group";
        return new CreativeItemGroup(modid, modid, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, ItemLike icon) {
        return CreativeItemGroup.create(modid, () -> icon.m_5456_().m_7968_());
    }

    public static CreativeModeTab getBuildingBlocks() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256788_);
    }

    public static CreativeModeTab getColoredBlocks() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256725_);
    }

    public static CreativeModeTab getNaturalBlocks() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256776_);
    }

    public static CreativeModeTab getFunctionalBlocks() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256791_);
    }

    public static CreativeModeTab getRedstoneBlocks() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_257028_);
    }

    public static CreativeModeTab getToolsAndUtilities() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256869_);
    }

    public static CreativeModeTab getCombat() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256797_);
    }

    public static CreativeModeTab getFoodAndDrinks() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256839_);
    }

    public static CreativeModeTab getIngredients() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256968_);
    }

    public static CreativeModeTab getSpawnEggs() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256731_);
    }

    public static CreativeModeTab getOperatorUtilities() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256837_);
    }

    public static CreativeModeTab getSearch() {
        return (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256750_);
    }

    private CreativeItemGroup(String modid, String identifier, String translationKey, Supplier<ItemStack> icon) {
        super(CreativeModeTab.m_257815_((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).m_257737_(icon).m_257941_((Component)TextComponents.translation(translationKey).get()));
        this.modid = modid;
        this.identifier = identifier;
        this.background = new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png");
        this.f_256824_ = (flags, output) -> this.applyFiller(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            if (event.getRegistryKey() == Registries.f_279569_) {
                event.register(Registries.f_279569_, new ResourceLocation(modid, identifier), () -> this);
            }
        });
    }

    private void applyFiller(Consumer<ItemStack> output) {
        if (this.filler != null) {
            this.filler.accept(output);
        }
    }

    public CreativeItemGroup filler(Consumer<Consumer<ItemStack>> filler) {
        this.filler = filler;
        return this;
    }

    public CreativeItemGroup sorter(Comparator<ItemStack> sorter) {
        this.sorter = sorter;
        return this;
    }

    public CreativeItemGroup sortAlphabetically() {
        return this.sorter(Comparator.comparing(stack -> TextComponents.itemStack(stack).format()));
    }

    public void m_269498_(CreativeModeTab.ItemDisplayParameters parameters) {
        super.m_269498_(parameters);
        if (this.sorter != null) {
            this.sortedDisplayItems = new ArrayList<ItemStack>(this.f_243839_);
            this.sortedDisplayItems.sort(this.sorter);
        }
    }

    public Collection<ItemStack> m_260957_() {
        return this.sortedDisplayItems == null ? super.m_260957_() : this.sortedDisplayItems;
    }

    public ResourceLocation getBackgroundLocation() {
        return this.background;
    }
}

