/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddUpgradeRecipe
extends CustomRecipe {
    public AddUpgradeRecipe(ResourceLocation name, CraftingBookCategory cat) {
        super(name, cat);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        return this.findContext(inv) != null;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, RegistryAccess access) {
        Context ctx = this.findContext(inv);
        if (ctx == null) {
            return ItemStack.f_41583_;
        }
        ItemStack ret = ctx.drawer.m_41777_();
        ret.m_41784_().m_128365_("tile", (Tag)ctx.data.write(ret.m_41784_().m_128469_("tile")));
        return ret;
    }

    @Nullable
    private Context findContext(CraftingContainer inv) {
        Context ret = new Context();
        for (int x = 0; x < inv.m_6643_(); ++x) {
            ItemStack stack = inv.m_8020_(x);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemDrawers) {
                if (!ret.drawer.m_41619_()) {
                    return null;
                }
                ret.drawer = stack;
                continue;
            }
            if (stack.m_41720_() instanceof ItemUpgrade) {
                ret.upgrades.add(stack);
                continue;
            }
            return null;
        }
        if (ret.drawer.m_41619_() || ret.upgrades.isEmpty()) {
            return null;
        }
        ret.data = new UpgradeData(7){

            @Override
            public boolean setUpgrade(int slot, @NotNull ItemStack upgrade) {
                if (upgrade.m_41619_()) {
                    return false;
                }
                upgrade = upgrade.m_41777_();
                upgrade.m_41764_(1);
                this.upgrades[slot] = upgrade;
                return true;
            }
        };
        if (ret.drawer.m_41782_() && ret.drawer.m_41783_().m_128441_("tile")) {
            ret.data.read(ret.drawer.m_41783_().m_128469_("tile"));
        }
        for (ItemStack upgrade : ret.upgrades) {
            if (upgrade.m_41720_() == ModItems.ONE_STACK_UPGRADE.get()) {
                return null;
            }
            if (!ret.data.hasEmptySlot() || !ret.data.canAddUpgrade(upgrade)) {
                return null;
            }
            ret.data.addUpgrade(upgrade);
        }
        return ret;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)StorageDrawers.UPGRADE_RECIPE_SERIALIZER.get();
    }

    private static class Context {
        ItemStack drawer = ItemStack.f_41583_;
        List<ItemStack> upgrades = new ArrayList<ItemStack>();
        UpgradeData data = null;

        private Context() {
        }
    }
}

