/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.ProxyBuilderModel;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public final class BasicDrawerModel {
    private static final Map<String, BakedModel> overlayModels = new HashMap<String, BakedModel>();
    private static final DynamicPart[] missingSlots1 = new DynamicPart[]{DynamicPart.MISSING_1};
    private static final DynamicPart[] missingSlots2 = new DynamicPart[]{DynamicPart.MISSING_1, DynamicPart.MISSING_2};
    private static final DynamicPart[] missingSlots4 = new DynamicPart[]{DynamicPart.MISSING_1, DynamicPart.MISSING_2, DynamicPart.MISSING_3, DynamicPart.MISSING_4};
    private static final DynamicPart[][] missingSlots = new DynamicPart[][]{missingSlots1, missingSlots2, new DynamicPart[0], missingSlots4};
    private static boolean geometryDataLoaded = false;

    static String getVariant(Direction dir, boolean half) {
        return "facing=" + dir.m_122433_() + ",half=" + half;
    }

    static String getVariant(Direction dir, boolean half, int slots) {
        return "facing=" + dir.m_122433_() + ",half=" + half + ",slots=" + slots;
    }

    static String getVariant(DynamicPart part, Direction dir, boolean half) {
        return "part=" + part.getName() + ",facing=" + dir.m_122433_() + ",half=" + half;
    }

    static String getVariant(DynamicPart part, Direction dir, boolean half, int slots) {
        return "part=" + part.getName() + ",facing=" + dir.m_122433_() + ",half=" + half + ",slots=" + slots;
    }

    public static enum DynamicPart {
        LOCK("lock"),
        VOID("void"),
        SHROUD("shroud"),
        INDICATOR("indicator"),
        MISSING_1("missing_1"),
        MISSING_2("missing_2"),
        MISSING_3("missing_3"),
        MISSING_4("missing_4");

        private String name;

        private DynamicPart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Model
    extends ProxyBuilderModel {
        Direction side;
        Map<Direction, BakedModel> overlays;

        public Model(BakedModel parent, Map<Direction, BakedModel> overlays, Direction side) {
            super(parent);
            this.overlays = overlays;
            this.side = side;
        }

        @Override
        protected BakedModel buildModel(BlockState state, BakedModel parent) {
            return new MergedModel(parent, this.overlays.get(this.side));
        }
    }

    public static class Model2
    implements IDynamicBakedModel {
        protected final BakedModel mainModel;

        public Model2(BakedModel mainModel) {
            this.mainModel = mainModel;
        }

        public boolean m_7547_() {
            return this.mainModel.m_7547_();
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType type) {
            IDrawerGroup group;
            BakedModel model;
            List mainQuads;
            if (state != null) {
                ChunkRenderTypeSet renderTypes = this.mainModel.getRenderTypes(state, rand, extraData);
                mainQuads = type == null || renderTypes.contains(type) ? this.mainModel.getQuads(state, side, rand, extraData, type) : Collections.emptyList();
            } else {
                return this.mainModel.getQuads(null, side, rand, extraData, type);
            }
            if (!extraData.has(BlockEntityDrawers.ATTRIBUTES)) {
                return mainQuads;
            }
            if (type != null && type != RenderType.m_110457_()) {
                return mainQuads;
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(mainQuads);
            IDrawerAttributes attr = (IDrawerAttributes)extraData.get(BlockEntityDrawers.ATTRIBUTES);
            Direction dir = (Direction)state.m_61143_((Property)BlockDrawers.f_54117_);
            boolean half = false;
            Block block = state.m_60734_();
            if (block instanceof BlockDrawers) {
                BlockDrawers drawers = (BlockDrawers)block;
                half = drawers.isHalfDepth();
            }
            if ((attr.isItemLocked(LockAttribute.LOCK_EMPTY) || attr.isItemLocked(LockAttribute.LOCK_POPULATED)) && (model = overlayModels.get(BasicDrawerModel.getVariant(DynamicPart.LOCK, dir, half))) != null) {
                quads.addAll(model.getQuads(state, side, rand, extraData, type));
            }
            if (attr.isVoid() && (model = overlayModels.get(BasicDrawerModel.getVariant(DynamicPart.VOID, dir, half))) != null) {
                quads.addAll(model.getQuads(state, side, rand, extraData, type));
            }
            if (attr.isConcealed() && (model = overlayModels.get(BasicDrawerModel.getVariant(DynamicPart.SHROUD, dir, half))) != null) {
                quads.addAll(model.getQuads(state, side, rand, extraData, type));
            }
            if (attr.hasFillLevel()) {
                int count;
                BakedModel model2;
                if (block instanceof BlockCompDrawers) {
                    model = overlayModels.get(BasicDrawerModel.getVariant(DynamicPart.INDICATOR, dir, half));
                    if (model != null) {
                        quads.addAll(model.getQuads(state, side, rand, extraData, type));
                    }
                } else if (block instanceof BlockDrawers && (model2 = overlayModels.get(BasicDrawerModel.getVariant(DynamicPart.INDICATOR, dir, half, count = ((BlockDrawers)block).getDrawerCount()))) != null) {
                    quads.addAll(model2.getQuads(state, side, rand, extraData, type));
                }
            }
            if (block instanceof BlockStandardDrawers && extraData.has(BlockEntityDrawers.DRAWER_GROUP) && (group = (IDrawerGroup)extraData.get(BlockEntityDrawers.DRAWER_GROUP)) != null) {
                int count = group.getDrawerCount();
                DynamicPart[] groupMissingSlots = missingSlots[count - 1];
                for (int i = 0; i < groupMissingSlots.length; ++i) {
                    BakedModel model3;
                    if (!group.getDrawer(i).isMissing() || (model3 = overlayModels.get(BasicDrawerModel.getVariant(groupMissingSlots[i], dir, half, count))) == null) continue;
                    quads.addAll(model3.getQuads(state, side, rand, extraData, type));
                }
            }
            return quads;
        }

        public boolean m_7541_() {
            return this.mainModel.m_7541_();
        }

        public boolean m_7539_() {
            return this.mainModel.m_7539_();
        }

        public boolean m_7521_() {
            return this.mainModel.m_7521_();
        }

        @NotNull
        public TextureAtlasSprite m_6160_() {
            return this.mainModel.m_6160_();
        }

        @NotNull
        public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
            return this.mainModel.getParticleIcon(data);
        }

        @NotNull
        public ItemOverrides m_7343_() {
            return this.mainModel.m_7343_();
        }

        @NotNull
        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110457_()}), this.mainModel.getRenderTypes(state, rand, data)});
        }

        @NotNull
        public List<RenderType> getRenderTypes(@NotNull ItemStack itemStack, boolean fabulous) {
            return Collections.emptyList();
        }

        @NotNull
        public List<BakedModel> getRenderPasses(@NotNull ItemStack itemStack, boolean fabulous) {
            return this.mainModel.getRenderPasses(itemStack, fabulous);
        }
    }

    public static class MergedModel
    implements IDynamicBakedModel {
        protected final BakedModel mainModel;
        protected final BakedModel[] models;

        public MergedModel(BakedModel mainModel, BakedModel ... models) {
            this.mainModel = mainModel;
            this.models = models;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType type) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.mainModel.getQuads(state, side, rand, data, type));
            for (BakedModel model : this.models) {
                quads.addAll(model.getQuads(state, side, rand, data, type));
            }
            return quads;
        }

        public boolean m_7541_() {
            return this.mainModel.m_7541_();
        }

        public boolean m_7539_() {
            return this.mainModel.m_7539_();
        }

        public boolean m_7547_() {
            return this.mainModel.m_7547_();
        }

        public boolean m_7521_() {
            return this.mainModel.m_7521_();
        }

        @NotNull
        public TextureAtlasSprite m_6160_() {
            return this.mainModel.m_6160_();
        }

        @NotNull
        public ItemOverrides m_7343_() {
            return this.mainModel.m_7343_();
        }
    }

    @Mod.EventBusSubscriber(modid="storagedrawers", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Register {
        @SubscribeEvent
        public static void registerTextures(TextureStitchEvent event) {
            if (!ModBlocks.OAK_FULL_DRAWERS_1.isPresent()) {
                StorageDrawers.log.warn("Block objects not set in TextureStitchEvent.  Is your mod environment broken?");
                return;
            }
            Register.loadGeometryData();
        }

        private static void loadGeometryData() {
            if (geometryDataLoaded) {
                return;
            }
            geometryDataLoaded = true;
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/full_drawers_icon_area_1.json"), StorageDrawers.rl("models/block/geometry/full_drawers_count_area_1.json"), StorageDrawers.rl("models/block/geometry/full_drawers_ind_area_1.json"), StorageDrawers.rl("models/block/geometry/full_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, false).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/full_drawers_icon_area_2.json"), StorageDrawers.rl("models/block/geometry/full_drawers_count_area_2.json"), StorageDrawers.rl("models/block/geometry/full_drawers_ind_area_2.json"), StorageDrawers.rl("models/block/geometry/full_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, false).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/full_drawers_icon_area_4.json"), StorageDrawers.rl("models/block/geometry/full_drawers_count_area_4.json"), StorageDrawers.rl("models/block/geometry/full_drawers_ind_area_4.json"), StorageDrawers.rl("models/block/geometry/full_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, false).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/half_drawers_icon_area_1.json"), StorageDrawers.rl("models/block/geometry/half_drawers_count_area_1.json"), StorageDrawers.rl("models/block/geometry/half_drawers_ind_area_1.json"), StorageDrawers.rl("models/block/geometry/half_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, true).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/half_drawers_icon_area_2.json"), StorageDrawers.rl("models/block/geometry/half_drawers_count_area_2.json"), StorageDrawers.rl("models/block/geometry/half_drawers_ind_area_2.json"), StorageDrawers.rl("models/block/geometry/half_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, true).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/half_drawers_icon_area_4.json"), StorageDrawers.rl("models/block/geometry/half_drawers_count_area_4.json"), StorageDrawers.rl("models/block/geometry/half_drawers_ind_area_4.json"), StorageDrawers.rl("models/block/geometry/half_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, true).toArray(BlockDrawers[]::new));
            Register.populateGeometryData(StorageDrawers.rl("models/block/geometry/comp_drawers_icon_area_3.json"), StorageDrawers.rl("models/block/geometry/comp_drawers_count_area_3.json"), StorageDrawers.rl("models/block/geometry/comp_drawers_ind_area_3.json"), StorageDrawers.rl("models/block/geometry/comp_drawers_indbase_area_3.json"), (BlockDrawers[])ModBlocks.getDrawersOfType(BlockCompDrawers.class).toArray(BlockDrawers[]::new));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static BlockModel getBlockModel(ResourceLocation location) {
            Resource iresource = null;
            InputStreamReader reader = null;
            try {
                iresource = Minecraft.m_91087_().m_91098_().m_215593_(location);
                reader = new InputStreamReader(iresource.m_215507_(), StandardCharsets.UTF_8);
                BlockModel blockModel = BlockModel.m_111461_((Reader)reader);
                IOUtils.closeQuietly((Reader)reader);
                return blockModel;
            }
            catch (IOException e) {
                BlockModel blockModel = null;
                return blockModel;
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
        }

        private static void populateGeometryData(ResourceLocation locationIcon, ResourceLocation locationCount, ResourceLocation locationInd, ResourceLocation locationIndBase, BlockDrawers ... blocks) {
            BlockModel slotInfo = Register.getBlockModel(locationIcon);
            BlockModel countInfo = Register.getBlockModel(locationCount);
            BlockModel indInfo = Register.getBlockModel(locationInd);
            BlockModel indBaseInfo = Register.getBlockModel(locationIndBase);
            for (BlockDrawers block : blocks) {
                Vector3f to;
                Vector3f from;
                int i;
                if (block == null) continue;
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)slotInfo.m_111436_().get((int)i)).f_111308_;
                    to = ((BlockElement)slotInfo.m_111436_().get((int)i)).f_111309_;
                    block.labelGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)countInfo.m_111436_().get((int)i)).f_111308_;
                    to = ((BlockElement)countInfo.m_111436_().get((int)i)).f_111309_;
                    block.countGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)indInfo.m_111436_().get((int)i)).f_111308_;
                    to = ((BlockElement)indInfo.m_111436_().get((int)i)).f_111309_;
                    block.indGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
                }
                for (i = 0; i < block.getDrawerCount(); ++i) {
                    from = ((BlockElement)indBaseInfo.m_111436_().get((int)i)).f_111308_;
                    to = ((BlockElement)indBaseInfo.m_111436_().get((int)i)).f_111309_;
                    block.indBaseGeometry[i] = new AABB((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
                }
            }
        }

        @SubscribeEvent
        public static void registerModels(ModelEvent.ModifyBakingResult event) {
            if (!ModBlocks.OAK_FULL_DRAWERS_1.isPresent()) {
                StorageDrawers.log.warn("Block objects not set in ModelBakeEvent.  Is your mod environment broken?");
                return;
            }
            for (int i = 0; i < 4; ++i) {
                Direction dir = Direction.m_122407_((int)i);
                BlockModelRotation rot = BlockModelRotation.m_119153_((int)0, (int)((int)dir.m_122435_() + 180));
                for (int j = 0; j < 2; ++j) {
                    boolean half = j == 1;
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.LOCK, dir, half), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_locked"), BasicDrawerModel.getVariant(dir, half))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.VOID, dir, half), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_void"), BasicDrawerModel.getVariant(dir, half))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.SHROUD, dir, half), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_shroud"), BasicDrawerModel.getVariant(dir, half))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.INDICATOR, dir, half, 1), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_indicator"), BasicDrawerModel.getVariant(dir, half, 1))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.INDICATOR, dir, half, 2), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_indicator"), BasicDrawerModel.getVariant(dir, half, 2))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.INDICATOR, dir, half, 4), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_indicator"), BasicDrawerModel.getVariant(dir, half, 4))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.INDICATOR, dir, half), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_comp_indicator"), BasicDrawerModel.getVariant(dir, half))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.MISSING_1, dir, half, 1), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_missing_slot_1_1"), BasicDrawerModel.getVariant(dir, half))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.MISSING_1, dir, half, 2), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_missing_slot_2_1"), BasicDrawerModel.getVariant(dir, half))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.MISSING_1, dir, half, 4), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_missing_slot_4_1"), BasicDrawerModel.getVariant(dir, half))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.MISSING_2, dir, half, 2), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_missing_slot_2_2"), BasicDrawerModel.getVariant(dir, half))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.MISSING_2, dir, half, 4), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_missing_slot_4_2"), BasicDrawerModel.getVariant(dir, half))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.MISSING_3, dir, half, 4), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_missing_slot_4_3"), BasicDrawerModel.getVariant(dir, half))));
                    overlayModels.put(BasicDrawerModel.getVariant(DynamicPart.MISSING_4, dir, half, 4), (BakedModel)event.getModels().get(new ModelResourceLocation(StorageDrawers.rl("meta_missing_slot_4_4"), BasicDrawerModel.getVariant(dir, half))));
                }
            }
            ModBlocks.getDrawers().forEach(blockDrawers -> Register.replaceBlock(event, blockDrawers));
        }

        public static void replaceBlock(ModelEvent.ModifyBakingResult event, BlockDrawers block) {
            BakedModel missing = (BakedModel)event.getModels().get(ModelBakery.f_119230_);
            for (BlockState state : block.m_49965_().m_61056_()) {
                ModelResourceLocation modelResource = BlockModelShaper.m_110895_((BlockState)state);
                BakedModel parentModel = (BakedModel)event.getModels().get(modelResource);
                if (parentModel == null) {
                    StorageDrawers.log.warn("Got back null model from ModelBakeEvent.ModelManager for resource " + modelResource.toString());
                    continue;
                }
                if (parentModel == missing) continue;
                event.getModels().put(modelResource, new Model2(parentModel));
            }
        }
    }
}

