/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class TurtleSuckCommand
implements TurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleSuckCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        Direction direction = this.direction.toWorldDir(turtle);
        Level world = turtle.getLevel();
        BlockPos turtlePosition = turtle.getPosition();
        BlockPos blockPosition = turtlePosition.m_121945_(direction);
        Direction side = direction.m_122424_();
        ContainerTransfer inventory = PlatformHelper.get().getContainer((ServerLevel)world, blockPosition, side);
        if (inventory != null) {
            int transferred = inventory.moveTo(TurtleUtil.getOffsetInventory(turtle), this.quantity);
            switch (transferred) {
                case -2: {
                    return TurtleCommandResult.failure("No space for items");
                }
                case -1: {
                    return TurtleCommandResult.failure("No items to take");
                }
            }
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        AABB aabb = new AABB((double)blockPosition.m_123341_(), (double)blockPosition.m_123342_(), (double)blockPosition.m_123343_(), (double)blockPosition.m_123341_() + 1.0, (double)blockPosition.m_123342_() + 1.0, (double)blockPosition.m_123343_() + 1.0);
        List list = world.m_6443_(ItemEntity.class, aabb, EntitySelector.f_20402_);
        if (list.isEmpty()) {
            return TurtleCommandResult.failure("No items to take");
        }
        for (ItemEntity entity : list) {
            ItemStack leaveStack;
            ItemStack storeStack;
            ItemStack stack = entity.m_32055_().m_41777_();
            if (stack.m_41613_() > this.quantity) {
                storeStack = stack.m_41620_(this.quantity);
                leaveStack = stack;
            } else {
                storeStack = stack;
                leaveStack = ItemStack.f_41583_;
            }
            int oldCount = storeStack.m_41613_();
            ItemStack remainder = InventoryUtil.storeItemsFromOffset(turtle.getInventory(), storeStack, turtle.getSelectedSlot());
            if (remainder.m_41613_() == oldCount) continue;
            if (remainder.m_41619_() && leaveStack.m_41619_()) {
                entity.m_146870_();
            } else if (remainder.m_41619_()) {
                entity.m_32045_(leaveStack);
            } else if (leaveStack.m_41619_()) {
                entity.m_32045_(remainder);
            } else {
                leaveStack.m_41769_(remainder.m_41613_());
                entity.m_32045_(leaveStack);
            }
            world.m_6798_(1000, turtlePosition, 0);
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No space for items");
    }
}

