/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;

final class RecipeWrapper
implements Consumer<FinishedRecipe> {
    private final Consumer<FinishedRecipe> add;
    private final RecipeSerializer<?> serializer;
    private final List<Consumer<JsonObject>> extend = new ArrayList<Consumer<JsonObject>>(0);

    RecipeWrapper(Consumer<FinishedRecipe> add, RecipeSerializer<?> serializer) {
        this.add = add;
        this.serializer = serializer;
    }

    public static RecipeWrapper wrap(RecipeSerializer<?> serializer, Consumer<FinishedRecipe> original) {
        return new RecipeWrapper(original, serializer);
    }

    public RecipeWrapper withExtraData(Consumer<JsonObject> extra) {
        this.extend.add(extra);
        return this;
    }

    public RecipeWrapper withResultTag(@Nullable CompoundTag resultTag) {
        if (resultTag == null) {
            return this;
        }
        this.extend.add(json -> {
            JsonObject object = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            object.addProperty("nbt", resultTag.toString());
        });
        return this;
    }

    public RecipeWrapper withResultTag(Consumer<CompoundTag> resultTag) {
        CompoundTag tag = new CompoundTag();
        resultTag.accept(tag);
        return this.withResultTag(tag);
    }

    @Override
    public void accept(FinishedRecipe finishedRecipe) {
        this.add.accept(new RecipeImpl(finishedRecipe, this.serializer, this.extend));
    }

    private record RecipeImpl(FinishedRecipe recipe, RecipeSerializer<?> serializer, List<Consumer<JsonObject>> extend) implements FinishedRecipe
    {
        public void m_7917_(JsonObject jsonObject) {
            this.recipe.m_7917_(jsonObject);
            for (Consumer<JsonObject> extender : this.extend) {
                extender.accept(jsonObject);
            }
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.recipe.m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.recipe.m_6448_();
        }
    }
}

