/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTask;
import dan200.computercraft.core.Logging;
import dan200.computercraft.core.computer.Computer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LuaContext
implements ILuaContext {
    private static final Logger LOG = LoggerFactory.getLogger(LuaContext.class);
    private final Computer computer;

    LuaContext(Computer computer) {
        this.computer = computer;
    }

    @Override
    public long issueMainThreadTask(LuaTask task) throws LuaException {
        long taskID = this.computer.getUniqueTaskId();
        Runnable iTask = () -> {
            try {
                Object[] results = task.execute();
                if (results != null) {
                    Object[] eventArguments = new Object[results.length + 2];
                    eventArguments[0] = taskID;
                    eventArguments[1] = true;
                    System.arraycopy(results, 0, eventArguments, 2, results.length);
                    this.computer.queueEvent("task_complete", eventArguments);
                } else {
                    this.computer.queueEvent("task_complete", new Object[]{taskID, true});
                }
            }
            catch (LuaException e) {
                this.computer.queueEvent("task_complete", new Object[]{taskID, false, e.getMessage()});
            }
            catch (Exception t) {
                LOG.error(Logging.JAVA_ERROR, "Error running task", (Throwable)t);
                this.computer.queueEvent("task_complete", new Object[]{taskID, false, "Java Exception Thrown: " + t});
            }
        };
        if (this.computer.queueMainThread(iTask)) {
            return taskID;
        }
        throw new LuaException("Task limit exceeded");
    }
}

