/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.asm;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.PeripheralType;
import dan200.computercraft.core.asm.Generator;
import dan200.computercraft.core.asm.GenericMethod;
import dan200.computercraft.core.asm.IntCache;
import dan200.computercraft.core.methods.MethodSupplier;
import dan200.computercraft.core.methods.NamedMethod;
import dan200.computercraft.core.methods.ObjectSource;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MethodSupplierImpl<T>
implements MethodSupplier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodSupplierImpl.class);
    private final List<GenericMethod> genericMethods;
    private final Generator<T> generator;
    private final IntCache<T> dynamic;
    private final Function<Object, String[]> dynamicMethods;
    private final ClassValue<List<NamedMethod<T>>> classCache = new ClassValue<List<NamedMethod<T>>>(){
        private final Function<Class<?>, List<NamedMethod<T>>> getter = Generator.catching(MethodSupplierImpl.this::getMethodsImpl, List.of());

        @Override
        protected List<NamedMethod<T>> computeValue(Class<?> type) {
            return this.getter.apply(type);
        }
    };

    MethodSupplierImpl(List<GenericMethod> genericMethods, Generator<T> generator, IntCache<T> dynamic, Function<Object, String[]> dynamicMethods) {
        this.genericMethods = genericMethods;
        this.generator = generator;
        this.dynamic = dynamic;
        this.dynamicMethods = dynamicMethods;
    }

    @Override
    public boolean forEachSelfMethod(Object object, MethodSupplier.UntargetedConsumer<T> consumer) {
        List<NamedMethod<T>> methods = this.getMethods(object.getClass());
        for (NamedMethod<T> method : methods) {
            consumer.accept(method.name(), method.method(), method);
        }
        String[] dynamicMethods = this.dynamicMethods.apply(object);
        if (dynamicMethods != null) {
            for (int i = 0; i < dynamicMethods.length; ++i) {
                consumer.accept(dynamicMethods[i], this.dynamic.get(i), null);
            }
        }
        return !methods.isEmpty() || dynamicMethods != null;
    }

    @Override
    public boolean forEachMethod(Object object, MethodSupplier.TargetedConsumer<T> consumer) {
        String[] dynamicMethods;
        boolean hasMethods;
        List<NamedMethod<T>> methods = this.getMethods(object.getClass());
        for (NamedMethod<T> method : methods) {
            consumer.accept(object, method.name(), method.method(), method);
        }
        boolean bl = hasMethods = !methods.isEmpty();
        if (object instanceof ObjectSource) {
            ObjectSource source = (ObjectSource)object;
            for (Object extra : source.getExtra()) {
                List<NamedMethod<T>> extraMethods = this.getMethods(extra.getClass());
                if (!extraMethods.isEmpty()) {
                    hasMethods = true;
                }
                for (NamedMethod<T> method : extraMethods) {
                    consumer.accept(extra, method.name(), method.method(), method);
                }
            }
        }
        if ((dynamicMethods = this.dynamicMethods.apply(object)) != null) {
            hasMethods = true;
            for (int i = 0; i < dynamicMethods.length; ++i) {
                consumer.accept(object, dynamicMethods[i], this.dynamic.get(i), null);
            }
        }
        return hasMethods;
    }

    @VisibleForTesting
    List<NamedMethod<T>> getMethods(Class<?> klass) {
        return this.classCache.get(klass);
    }

    private List<NamedMethod<T>> getMethodsImpl(Class<?> klass) {
        ArrayList<NamedMethod<T>> methods = null;
        for (Method method : klass.getMethods()) {
            LuaFunction annotation = method.getAnnotation(LuaFunction.class);
            if (annotation == null) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                LOG.warn("LuaFunction method {}.{} should be an instance method.", method.getDeclaringClass(), (Object)method.getName());
                continue;
            }
            T instance = this.generator.getInstanceMethod(method).orElse(null);
            if (instance == null) continue;
            if (methods == null) {
                methods = new ArrayList<NamedMethod<T>>();
            }
            this.addMethod(methods, method, annotation, null, instance);
        }
        for (GenericMethod method : this.genericMethods) {
            T instance;
            if (!method.target.isAssignableFrom(klass) || (instance = this.generator.getGenericMethod(method).orElse(null)) == null) continue;
            if (methods == null) {
                methods = new ArrayList();
            }
            this.addMethod(methods, method.method, method.annotation, method.peripheralType, instance);
        }
        if (methods == null) {
            return List.of();
        }
        methods.trimToSize();
        return Collections.unmodifiableList(methods);
    }

    private void addMethod(List<NamedMethod<T>> methods, Method method, LuaFunction annotation, @Nullable PeripheralType genericType, T instance) {
        boolean isSimple;
        String[] names = annotation.value();
        boolean bl = isSimple = method.getReturnType() != MethodResult.class && !annotation.mainThread();
        if (names.length == 0) {
            methods.add(new NamedMethod<T>(method.getName(), instance, isSimple, genericType));
        } else {
            for (String name : names) {
                methods.add(new NamedMethod<T>(name, instance, isSimple, genericType));
            }
        }
    }
}

