/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

public class ItemToast
implements Toast {
    public static final Object TRANSFER_NO_RESPONSE_TOKEN = new Object();
    private static final long DISPLAY_TIME = 7000L;
    private static final int MAX_LINE_SIZE = 200;
    private static final int IMAGE_SIZE = 16;
    private static final int LINE_SPACING = 10;
    private static final int MARGIN = 8;
    private final ItemStack stack;
    private final Component title;
    private final List<FormattedCharSequence> message;
    private final Object token;
    private final int width;
    private boolean isNew = true;
    private long firstDisplay;

    public ItemToast(Minecraft minecraft, ItemStack stack, Component title, Component message, Object token) {
        this.stack = stack;
        this.title = title;
        this.token = token;
        Font font = minecraft.f_91062_;
        this.message = font.m_92923_((FormattedText)message, 200);
        this.width = Math.max(200, this.message.stream().mapToInt(arg_0 -> ((Font)font).m_92724_(arg_0)).max().orElse(200)) + 24 + 16;
    }

    public void showOrReplace(ToastComponent toasts) {
        ItemToast existing = (ItemToast)toasts.m_94926_(ItemToast.class, this.m_7283_());
        if (existing != null) {
            existing.isNew = true;
        } else {
            toasts.m_94922_((Toast)this);
        }
    }

    public int m_7828_() {
        return this.width;
    }

    public int m_94899_() {
        return 26 + this.message.size() * 10;
    }

    public Object m_7283_() {
        return this.token;
    }

    public Toast.Visibility m_7172_(GuiGraphics graphics, ToastComponent component, long time) {
        if (this.isNew) {
            this.firstDisplay = time;
            this.isNew = false;
        }
        if (this.width == 160 && this.message.size() <= 1) {
            graphics.m_280218_(f_94893_, 0, 0, 0, 64, this.width, this.m_94899_());
        } else {
            int height = this.m_94899_();
            int bottom = Math.min(4, height - 28);
            ItemToast.renderBackgroundRow(graphics, this.width, 0, 0, 28);
            for (int i = 28; i < height - bottom; i += 10) {
                ItemToast.renderBackgroundRow(graphics, this.width, 16, i, Math.min(16, height - i - bottom));
            }
            ItemToast.renderBackgroundRow(graphics, this.width, 32 - bottom, height - bottom, bottom);
        }
        int textX = 8;
        if (!this.stack.m_41619_()) {
            textX += 24;
            graphics.m_280203_(this.stack, 8, 8 + this.m_94899_() / 2 - 16);
        }
        graphics.m_280614_(component.m_94929_().f_91062_, this.title, textX, 8, -11534256, false);
        for (int i = 0; i < this.message.size(); ++i) {
            graphics.m_280649_(component.m_94929_().f_91062_, this.message.get(i), textX, 10 + (i + 1) * 10, -16777216, false);
        }
        return time - this.firstDisplay < 7000L ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    private static void renderBackgroundRow(GuiGraphics graphics, int x, int u, int y, int height) {
        int leftOffset = 5;
        int rightOffset = Math.min(60, x - leftOffset);
        graphics.m_280218_(f_94893_, 0, y, 0, 32 + u, leftOffset, height);
        for (int k = leftOffset; k < x - rightOffset; k += 64) {
            graphics.m_280218_(f_94893_, k, y, 32, 32 + u, Math.min(64, x - k - rightOffset), height);
        }
        graphics.m_280218_(f_94893_, x - rightOffset, y, 160 - rightOffset, 32 + u, rightOffset, height);
    }
}

