/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import net.optifine.Config;
import net.optifine.shaders.Shaders;
import net.optifine.util.MathUtils;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class ShadowFrustum
extends fmw {
    public ShadowFrustum(Matrix4f matrixIn, Matrix4f projectionIn) {
        super(matrixIn, projectionIn);
        this.extendForShadows(matrixIn, projectionIn);
        this.usePlanes = true;
    }

    private void extendForShadows(Matrix4f matrixIn, Matrix4f projectionIn) {
        few world = Config.getMinecraft().s;
        if (world == null) {
            return;
        }
        Matrix4f matrixFull = MathUtils.copy((Matrix4f)projectionIn);
        matrixFull.mul((Matrix4fc)matrixIn);
        matrixFull.transpose();
        Vector4f viewUp = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
        MathUtils.transform((Vector4f)viewUp, (Matrix4f)matrixFull);
        viewUp.normalize();
        Vector4f viewRight = new Vector4f(-1.0f, 0.0f, 0.0f, 0.0f);
        MathUtils.transform((Vector4f)viewRight, (Matrix4f)matrixFull);
        viewRight.normalize();
        float partialTicks = 0.0f;
        float car = world.a(partialTicks);
        float sunTiltRad = Shaders.sunPathRotation * apa.deg2Rad;
        float sar = car > apa.PId2 && car < 3.0f * apa.PId2 ? car + (float)Math.PI : car;
        float sx = -apa.a((float)sar);
        float sy = apa.b((float)sar) * apa.b((float)sunTiltRad);
        float sz = -apa.b((float)sar) * apa.a((float)sunTiltRad);
        Vector4f vecSun = new Vector4f(sx, sy, sz, 0.0f);
        vecSun.normalize();
        Vector3f viewUpDot = MathUtils.makeVector3f((Vector4f)viewUp);
        viewUpDot.mul(viewUp.dot((Vector4fc)vecSun));
        Vector3f vecSunH3 = MathUtils.makeVector3f((Vector4f)vecSun);
        vecSunH3.sub((Vector3fc)viewUpDot);
        vecSunH3.normalize();
        Vector4f vecSunH = new Vector4f(vecSunH3.x(), vecSunH3.y(), vecSunH3.z(), 0.0f);
        Vector3f viewRightDot = MathUtils.makeVector3f((Vector4f)viewRight);
        viewRightDot.mul(viewRight.dot((Vector4fc)vecSun));
        Vector3f vecSunV3 = MathUtils.makeVector3f((Vector4f)vecSun);
        vecSunV3.sub((Vector3fc)viewRightDot);
        vecSunV3.normalize();
        Vector4f vecSunV = new Vector4f(vecSunV3.x(), vecSunV3.y(), vecSunV3.z(), 0.0f);
        Vector4f vecRight = this.frustum[0];
        Vector4f vecLeft = this.frustum[1];
        Vector4f vecTop = this.frustum[2];
        Vector4f vecBottom = this.frustum[3];
        Vector4f vecFar = this.frustum[4];
        Vector4f vecNear = this.frustum[5];
        vecRight.normalize();
        vecLeft.normalize();
        vecTop.normalize();
        vecBottom.normalize();
        vecFar.normalize();
        vecNear.normalize();
        float dotRight = vecRight.dot((Vector4fc)vecSunH);
        float dotLeft = vecLeft.dot((Vector4fc)vecSunH);
        float dotTop = vecTop.dot((Vector4fc)vecSunV);
        float dotBottom = vecBottom.dot((Vector4fc)vecSunV);
        float farPlaneDistance = Config.getGameRenderer().l();
        float mulFarDist = Config.isFogOff() ? 1.414f : 1.0f;
        float rotRight = 0.0f;
        float rotLeft = 0.0f;
        if (dotRight < 0.0f || dotLeft < 0.0f) {
            vecNear.add(0.0f, 0.0f, 0.0f, farPlaneDistance);
            if (dotRight < 0.0f && dotLeft < 0.0f) {
                rotRight = this.rotateDotPlus(vecRight, vecSunH, -1, viewUp);
                rotLeft = this.rotateDotPlus(vecLeft, vecSunH, 1, viewUp);
                vecRight.set(-vecRight.x(), -vecRight.y(), -vecRight.z(), -vecRight.w());
                vecLeft.set(-vecLeft.x(), -vecLeft.y(), -vecLeft.z(), -vecLeft.w());
                float distRight = -dotRight * farPlaneDistance * mulFarDist;
                float distLeft = -dotLeft * farPlaneDistance * mulFarDist;
                vecRight.add(0.0f, 0.0f, 0.0f, distRight);
                vecLeft.add(0.0f, 0.0f, 0.0f, distLeft);
            } else if (dotRight < 0.0f) {
                rotRight = this.rotateDotPlus(vecRight, vecSunH, -1, viewUp);
            } else {
                rotLeft = this.rotateDotPlus(vecLeft, vecSunH, 1, viewUp);
            }
        }
        int minWorldHeight = world.C_();
        int maxWorldHeight = world.aj();
        float eyeHeight = (int)Config.getMinecraft().t.dr();
        float maxDistBottom = Config.limit((float)(eyeHeight - (float)minWorldHeight), (float)0.0f, (float)farPlaneDistance);
        float maxDistTop = Config.limit((float)((float)maxWorldHeight - eyeHeight), (float)0.0f, (float)farPlaneDistance);
        float rotTop = 0.0f;
        float rotBottom = 0.0f;
        if (dotTop < 0.0f || dotBottom < 0.0f) {
            vecNear.add(0.0f, 0.0f, 0.0f, farPlaneDistance);
            if (dotTop < 0.0f && dotBottom < 0.0f) {
                rotTop = this.rotateDotPlus(vecTop, vecSunV, -1, viewRight);
                rotBottom = this.rotateDotPlus(vecBottom, vecSunV, 1, viewRight);
                vecTop.set(-vecTop.x(), -vecTop.y(), -vecTop.z(), -vecTop.w());
                vecBottom.set(-vecBottom.x(), -vecBottom.y(), -vecBottom.z(), -vecBottom.w());
                float distTop = -dotTop * maxDistTop;
                float distBottom = -dotBottom * maxDistBottom;
                vecTop.add(0.0f, 0.0f, 0.0f, distTop);
                vecBottom.add(0.0f, 0.0f, 0.0f, distBottom);
            } else if (dotTop < 0.0f) {
                rotTop = this.rotateDotPlus(vecTop, vecSunV, -1, viewRight);
            } else {
                rotBottom = this.rotateDotPlus(vecBottom, vecSunV, 1, viewRight);
            }
        }
    }

    private float rotateDotPlus(Vector4f vecFrustum, Vector4f vecSun, int angleDeg, Vector4f vecRot) {
        float dot;
        Vector3f vecRot3 = MathUtils.makeVector3f((Vector4f)vecRot);
        Quaternionf rot = MathUtils.rotationDegrees((Vector3f)vecRot3, (float)angleDeg);
        float angleDegSum = 0.0f;
        while (!((dot = vecFrustum.dot((Vector4fc)vecSun)) >= 0.0f)) {
            MathUtils.transform((Vector4f)vecFrustum, (Quaternionf)rot);
            vecFrustum.normalize();
            angleDegSum += (float)angleDeg;
        }
        return angleDegSum;
    }
}

