/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import net.optifine.render.IBufferSourceListener;

public class RenderCache
implements IBufferSourceListener {
    private long cacheTimeMs;
    private long updateTimeMs;
    private Map<fkf, ByteBuffer> renderTypeBuffers = new LinkedHashMap();
    private Deque<ByteBuffer> freeBuffers = new ArrayDeque();

    public RenderCache(long cacheTimeMs) {
        this.cacheTimeMs = cacheTimeMs;
    }

    public boolean drawCached(eox graphicsIn) {
        if (this.renderTypeBuffers.isEmpty() || System.currentTimeMillis() > this.updateTimeMs) {
            graphicsIn.e();
            for (ByteBuffer bb : this.renderTypeBuffers.values()) {
                this.freeBuffers.add(bb);
            }
            this.renderTypeBuffers.clear();
            this.updateTimeMs = System.currentTimeMillis() + this.cacheTimeMs;
            return false;
        }
        for (fkf rt : this.renderTypeBuffers.keySet()) {
            ByteBuffer bb = (ByteBuffer)this.renderTypeBuffers.get(rt);
            graphicsIn.putBulkData(rt, bb);
            bb.rewind();
        }
        graphicsIn.e();
        return true;
    }

    public void startRender(eox graphicsIn) {
        graphicsIn.d().addListener((IBufferSourceListener)this);
    }

    public void stopRender(eox graphicsIn) {
        graphicsIn.e();
        graphicsIn.d().removeListener((IBufferSourceListener)this);
    }

    public void finish(fkf renderTypeIn, eie bufferIn) {
        ByteBuffer bb = (ByteBuffer)this.renderTypeBuffers.get(renderTypeIn);
        if (bb == null) {
            bb = this.allocateByteBuffer(524288);
            this.renderTypeBuffers.put(renderTypeIn, bb);
        }
        bb.position(bb.limit());
        bb.limit(bb.capacity());
        bufferIn.getBulkData(bb);
        bb.flip();
    }

    private ByteBuffer allocateByteBuffer(int size) {
        ByteBuffer bb = (ByteBuffer)this.freeBuffers.pollLast();
        if (bb == null) {
            bb = ehh.a((int)size);
        }
        bb.position(0);
        bb.limit(0);
        return bb;
    }
}

