/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private bfj entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<gu> setLitChunkPos = new HashSet();
    private gu.a blockPosMutable = new gu.a();

    public DynamicLight(bfj entity) {
        this.entity = entity;
        this.offsetY = entity.cF();
    }

    public void update(fjv renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dn() - 0.5;
        double posY = this.entity.dp() - 0.5 + this.offsetY;
        double posZ = this.entity.dt() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((bfj)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            ha dirX = (apa.a((double)posX) & 0xF) >= 8 ? ha.f : ha.e;
            ha dirY = (apa.a((double)posY) & 0xF) >= 8 ? ha.b : ha.a;
            ha dirZ = (apa.a((double)posZ) & 0xF) >= 8 ? ha.d : ha.c;
            gu chunkPos = gu.a((double)posX, (double)posY, (double)posZ);
            fmp.c chunk = renderGlobal.getRenderChunk(chunkPos);
            gu chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            fmp.c chunkX = renderGlobal.getRenderChunk(chunkPosX);
            gu chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            fmp.c chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            gu chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            fmp.c chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            gu chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            fmp.c chunkY = renderGlobal.getRenderChunk(chunkPosY);
            gu chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            fmp.c chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            gu chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            fmp.c chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            gu chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            fmp.c chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private gu getChunkPos(fmp.c renderChunk, gu pos, ha facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(fmp.c renderChunk, Set<gu> setPrevPos, Set<gu> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        fmp.b compiledChunk = renderChunk.d();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        gu pos = renderChunk.f().i();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(fjv renderGlobal) {
        for (gu posOld : this.setLitChunkPos) {
            fmp.c chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public bfj getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

